/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin.impl;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwMenuDao;
import com.cpi.framework.web.entity.admin.FwMenu;
import com.cpi.framework.web.service.admin.IFwMenuService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FwMenuServiceImpl")
public class FwMenuServiceImpl
extends BaseServiceImpl<FwMenu, Long>
implements IFwMenuService {
    @Resource(name="FwMenuDaoImpl")
    private IFwMenuDao fwMenuDao;

    @Resource(name="FwMenuDaoImpl")
    public void setBaseDao(IFwMenuDao fwMenuDao) {
        super.setBaseDao(fwMenuDao);
    }

    @Override
    @Transactional(readOnly=true)
    public FwMenu findMenu(Long menuId) {
        return (FwMenu)this.fwMenuDao.find(menuId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FwMenu> findChildMenus(Long pMenuId) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filter.eq("parentId", pMenuId));
        filters.add(Filter.eq("isDisplay", (Object)StatusEnum.Y));
        List<FwMenu> fwMenus = super.findList(null, filters, null);
        if (fwMenus != null) {
            Subject curentUser = SecurityUtils.getSubject();
            Iterator it = fwMenus.iterator();
            while (it.hasNext()) {
                FwMenu fwMenu = (FwMenu)it.next();
                if (curentUser.isPermitted(MessageFormat.format("menu:view:{0}", fwMenu.getId()))) continue;
                it.remove();
            }
            return fwMenus;
        }
        return null;
    }
}

