/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin.impl;

import com.cpi.framework.modules.utils.DateUtils;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwMailService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="FwMailServiceImpl")
public class FwMailServiceImpl
implements IFwMailService {
    @Resource(name="javaMailSender")
    private JavaMailSenderImpl javaMailSender;
    @Resource(name="taskExecutor")
    private TaskExecutor taskExecutor;
    @Resource(name="FwUserDaoImpl")
    private IFwUserDao fwUserDao;

    private void addSendTask(final MimeMessage mimeMessage) {
        try {
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    FwMailServiceImpl.this.javaMailSender.send(mimeMessage);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(String toMail, String subject, boolean async) {
        Assert.hasText((String)toMail);
        Assert.hasText((String)subject);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\u5404\u4f4d\u9886\u5bfc\u3001\u540c\u4e8b\uff1a<br><br>");
            sb.append("<div style='text-indent:8mm;'>\u8bf7\u5728\u5468\u56db\u5b8c\u6210\u672c\u5468\u7684\u5de5\u65f6\u586b\u62a5\u3002<br><br><br></div>");
            sb.append("<div style='text-indent:40mm;'>\u9879\u76ee\u7ec4<br></div>");
            sb.append("<div style='text-indent:32mm;'>" + DateUtils.getNow() + "</div>");
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
            mimeMessageHelper.setFrom(" <" + this.javaMailSender.getUsername() + ">");
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setTo(toMail);
            mimeMessageHelper.setText(sb.toString(), true);
            if (async) {
                this.addSendTask(mimeMessage);
            } else {
                this.javaMailSender.send(mimeMessage);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendAll(String subject, boolean async) {
        ArrayList<FwOrg> fwOrgs = new ArrayList<FwOrg>();
        fwOrgs.add(new FwOrg(2L));
        fwOrgs.add(new FwOrg(3L));
        fwOrgs.add(new FwOrg(4L));
        List<FwUser> fwUsers = this.fwUserDao.findUsersNotInOrgs(fwOrgs);
        for (FwUser fwUser : fwUsers) {
            this.send(fwUser.getEmail(), subject, async);
        }
    }
}

