/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin.impl;

import com.cpi.framework.web.service.admin.IFwCacheService;
import java.io.IOException;
import javax.annotation.Resource;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang.StringUtils;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service(value="FwCacheServiceImpl")
public class FwCacheServiceImpl
implements IFwCacheService {
    @Resource(name="cacheManager")
    private org.springframework.cache.CacheManager cacheManager;
    @Resource(name="ehCacheManager")
    private CacheManager shiroEhcacheManager;
    @Resource(name="messageSource")
    private ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource;

    @Override
    public void clearCache() {
        this.reloadableResourceBundleMessageSource.clearCache();
        if (this.shiroEhcacheManager != null) {
            this.shiroEhcacheManager.clearAll();
        }
        if (this.cacheManager != null && this.cacheManager instanceof CacheManager) {
            ((CacheManager)this.cacheManager).clearAll();
        }
    }

    @Override
    public void clearCache(String cacheName) {
        if (StringUtils.isNotBlank((String)cacheName)) {
            if (this.shiroEhcacheManager != null) {
                this.shiroEhcacheManager.getCache(cacheName).removeAll();
            }
            if (this.cacheManager != null) {
                if (this.cacheManager instanceof CacheManager) {
                    ((CacheManager)this.cacheManager).getCache(cacheName).removeAll();
                }
                if (this.cacheManager instanceof CompositeCacheManager) {
                    try {
                        ((CompositeCacheManager)this.cacheManager).getCache(cacheName).removeAll();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

