/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.modules.security.shiro.FwAuthenticationToken;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwPermissions;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;

public class ShiroDbRealm
extends AuthorizingRealm {
    @Resource(name="FwUserDaoImpl")
    private IFwUserDao fwUsernDao;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        FwAuthenticationToken token = (FwAuthenticationToken)authcToken;
        String username = token.getUsername();
        Long companyId = token.getCompanyId();
        FwUser user = this.fwUsernDao.findByLoginName(username);
        if (user != null) {
            return new SimpleAuthenticationInfo((Object)new Principal(user.getId(), username, user.getUsername(), user.getOrgId().getId(), companyId), (Object)user.getPassword(), ByteSource.Util.bytes((byte[])"cpi".getBytes()), this.getName());
        }
        throw new UnknownAccountException();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Principal principal = (Principal)principals.getPrimaryPrincipal();
        if (principal != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            FwUser fwUser = (FwUser)this.fwUsernDao.find(principal.getId());
            if (fwUser != null) {
                for (FwRoles fwRole : fwUser.getFwRoles()) {
                    info.addRole(String.valueOf(fwRole.getId()));
                }
                info.addStringPermissions(this.getPermissonCode(fwUser));
            }
            return info;
        }
        return null;
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("MD5");
        matcher.setHashIterations(2);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    private Set<String> getPermissonCode(FwUser fwUser) {
        HashSet<String> fwPermissonCode = new HashSet<String>();
        if (fwUser != null) {
            HashSet<FwPermissions> fwPermissons = new HashSet<FwPermissions>();
            fwPermissons.addAll(fwUser.getFwPermissions());
            for (FwRoles role : fwUser.getFwRoles()) {
                fwPermissons.addAll(role.getFwPermissions());
            }
            fwPermissons.addAll(fwUser.getStId().getFwPermissions());
            for (FwPermissions fwPermisson : fwPermissons) {
                fwPermissonCode.add(fwPermisson.getPermissionCode());
            }
        }
        return fwPermissonCode;
    }

    private void setSession(Object key, Object value) {
        Session session;
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser && null != (session = currentUser.getSession())) {
            session.setAttribute(key, value);
        }
    }
}

