/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.entity.admin;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwPermissions;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwStation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="FW_USER")
public class FwUser
extends SortEntity {
    private static final long serialVersionUID = 1L;
    private String logincode;
    private String username;
    private FwOrg orgId;
    private FwStation stId;
    private String password;
    private String telephone;
    private String email;
    private sexEnum sex;
    private String identification;
    private Date birthday;
    private StatusEnum status;
    private String memo;
    private Set<FwRoles> fwRoles = new HashSet<FwRoles>();
    private Set<FwPermissions> fwPermissions = new HashSet<FwPermissions>();

    public FwUser() {
    }

    public FwUser(Long id) {
        super.setId(id);
    }

    @Temporal(value=TemporalType.DATE)
    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public String getLogincode() {
        return this.logincode;
    }

    public void setLogincode(String logincode) {
        this.logincode = logincode;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwOrg getOrgId() {
        return this.orgId;
    }

    public void setOrgId(FwOrg orgId) {
        this.orgId = orgId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=1)
    public sexEnum getSex() {
        return this.sex;
    }

    public void setSex(sexEnum sex) {
        this.sex = sex;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=1)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwStation getStId() {
        return this.stId;
    }

    public void setStId(FwStation stId) {
        this.stId = stId;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="FW_USER_ROLES", joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="ROLE_ID")})
    @OrderBy(value="orderNo ASC")
    @JsonIgnore
    public Set<FwRoles> getFwRoles() {
        return this.fwRoles;
    }

    public void setFwRoles(Set<FwRoles> fwRoles) {
        this.fwRoles = fwRoles;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="FW_USER_PERMISSIONS", joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="PERMISSION_ID")})
    @OrderBy(value="orderNo ASC")
    @JsonIgnore
    public Set<FwPermissions> getFwPermissions() {
        return this.fwPermissions;
    }

    public void setFwPermissions(Set<FwPermissions> fwPermissions) {
        this.fwPermissions = fwPermissions;
    }

    @JsonIgnore
    @Transient
    public boolean isSuperAdminRole() {
        Set<FwRoles> fwRoles = this.getFwRoles();
        for (FwRoles role : fwRoles) {
            if (!FwRoles.RoleEnum.superAdmin.equals((Object)role.getRoleType()) && !FwRoles.RoleEnum.admin.equals((Object)role.getRoleType())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    @Transient
    public Long getCompanyId() {
        FwOrg fwOrg;
        for (fwOrg = this.getOrgId(); fwOrg != null && !FwOrg.orgEnum.company.equals((Object)fwOrg.getOrgType()); fwOrg = fwOrg.getpId()) {
        }
        return fwOrg != null ? fwOrg.getId() : null;
    }

    public void addRoles(FwRoles fwRole) {
        this.fwRoles.add(fwRole);
    }

    public void removeRoles(FwRoles fwRole) {
        if (this.fwRoles.contains(fwRole)) {
            this.fwRoles.remove(fwRole);
        }
    }

    @Transient
    public String getOrgName() {
        return this.orgId.getOrgName();
    }

    @Transient
    public String getStName() {
        return this.stId.getStName();
    }

    @Transient
    public Long getOrgCode() {
        return this.orgId.getId();
    }

    @Transient
    public Long getStationId() {
        return this.stId.getId();
    }

    public static enum sexEnum {
        M,
        F;

    }
}

