/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.entity.admin;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwStation;
import com.cpi.framework.web.entity.admin.FwUser;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="FW_ORG")
public class FwOrg
extends SortEntity {
    private static final long serialVersionUID = 1L;
    private String orgCode;
    private String orgName;
    private FwOrg pId;
    private orgEnum orgType;
    private StatusEnum status;
    private String memo;
    private Set<FwOrg> children = new HashSet<FwOrg>();
    private Set<FwUser> fwUsers = new HashSet<FwUser>();
    private Set<FwRoles> fwRoles = new HashSet<FwRoles>();
    private Set<FwStation> fwStations = new HashSet<FwStation>();

    public FwOrg() {
    }

    public FwOrg(Long id) {
        super.setId(id);
    }

    @Column(name="ORG_CODE", unique=true, nullable=false, length=32)
    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Column(name="ORG_NAME", nullable=false, length=128)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ORG_TYPE")
    public orgEnum getOrgType() {
        return this.orgType;
    }

    public void setOrgType(orgEnum orgType) {
        this.orgType = orgType;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="STATUS", nullable=false, length=1)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Column(name="MEMO", length=256)
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwOrg getpId() {
        return this.pId;
    }

    public void setpId(FwOrg pId) {
        this.pId = pId;
    }

    @JsonIgnore
    @OneToMany(mappedBy="pId", fetch=FetchType.LAZY)
    @OrderBy(value="orderNo asc")
    public Set<FwOrg> getChildren() {
        return this.children;
    }

    public void setChildren(Set<FwOrg> children) {
        this.children = children;
    }

    @JsonIgnore
    @OneToMany(mappedBy="orgId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @OrderBy(value="orderNo asc")
    public Set<FwUser> getFwUsers() {
        return this.fwUsers;
    }

    public void setFwUsers(Set<FwUser> fwUsers) {
        this.fwUsers = fwUsers;
    }

    @JsonIgnore
    @OneToMany(mappedBy="orgId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @OrderBy(value="orderNo asc")
    public Set<FwRoles> getFwRoles() {
        return this.fwRoles;
    }

    public void setFwRoles(Set<FwRoles> fwRoles) {
        this.fwRoles = fwRoles;
    }

    @JsonIgnore
    @OneToMany(mappedBy="orgId", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    @OrderBy(value="orderNo asc")
    public Set<FwStation> getFwStations() {
        return this.fwStations;
    }

    public void setFwStations(Set<FwStation> fwStations) {
        this.fwStations = fwStations;
    }

    public static enum orgEnum {
        company,
        departments;

    }
}

