/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.entity.admin;

import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.StatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="FW_MENU")
public class FwMenu
extends SortEntity {
    private static final long serialVersionUID = 1L;
    private String menuName;
    private FwMenu parentId;
    private MenuEnum menuType;
    private businessEnum businessType;
    private String menuUrl;
    private String menuIco;
    private String permissons;
    private StatusEnum isDisplay;
    private Set<FwMenu> children = new HashSet<FwMenu>();

    @Column(name="MENU_NAME", nullable=false)
    public String getMenuName() {
        return this.menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    public FwMenu getParentId() {
        return this.parentId;
    }

    public void setParentId(FwMenu parentId) {
        this.parentId = parentId;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="MENU_TYPE", nullable=false)
    public MenuEnum getMenuType() {
        return this.menuType;
    }

    public void setMenuType(MenuEnum menuType) {
        this.menuType = menuType;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="BUSINESS_TYPE", nullable=false)
    public businessEnum getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(businessEnum businessType) {
        this.businessType = businessType;
    }

    @Column(name="MENU_URL", length=512)
    public String getMenuUrl() {
        return this.menuUrl;
    }

    public void setMenuUrl(String menuUrl) {
        this.menuUrl = menuUrl;
    }

    @Column(name="MENU_ICO", length=128)
    public String getMenuIco() {
        return this.menuIco;
    }

    public void setMenuIco(String menuIco) {
        this.menuIco = menuIco;
    }

    @Column(name="PERMISSONS", nullable=false)
    public String getPermissons() {
        return this.permissons;
    }

    public void setPermissons(String permissons) {
        this.permissons = permissons;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="IS_DISPLAY", nullable=false, length=1)
    public StatusEnum getIsDisplay() {
        return this.isDisplay;
    }

    public void setIsDisplay(StatusEnum isDisplay) {
        this.isDisplay = isDisplay;
    }

    @JsonIgnore
    @OneToMany(mappedBy="parentId", fetch=FetchType.LAZY)
    @OrderBy(value="orderNo asc")
    public Set<FwMenu> getChildren() {
        return this.children;
    }

    public void setChildren(Set<FwMenu> children) {
        this.children = children;
    }

    public static enum businessEnum {
        manager,
        business;

    }

    public static enum MenuEnum {
        folder,
        page;

    }
}

