/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.controller;

import com.cpi.framework.core.spring.SpringContextHolder;
import com.cpi.framework.modules.utils.CustomDateEditor;
import com.cpi.framework.modules.utils.CustomLongEditor;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.common.utils.AjaxUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyEditor;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class BaseController {
    public static final String EXCEPTION_MESSAGE = "EXCEPTION_MESSAGE";
    public static final String FLASH_MESSAGE = "FLASH_MESSAGE";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper mapper = new ObjectMapper();

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(true));
        binder.registerCustomEditor(Long.class, (PropertyEditor)new CustomLongEditor(true));
    }

    @ExceptionHandler
    public void handleException(Exception exception, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        request.setAttribute(EXCEPTION_MESSAGE, (Object)exception);
        if (!AjaxUtil.isAjaxRequest(request)) {
            throw exception;
        }
        String errorMsg = exception.getMessage();
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? "" : errorMsg.replace("\r\n", "");
        StackTraceElement[] ste = exception.getStackTrace();
        StringBuffer detailmessage = new StringBuffer();
        for (int i = 0; i < ste.length; ++i) {
            detailmessage.append(ste[i]).append("\\t");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inftype", 2);
        map.put("showdetial", "");
        map.put("clientCode", errorMsg);
        map.put("message", "\u64cd\u4f5c\u5931\u8d25!!!");
        map.put("detailmessage", detailmessage);
        map.put("callback", "");
        ResponseData data = ResponseData.error(null, map);
        try {
            String json = this.mapper.writeValueAsString((Object)data);
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().write(json);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected String message(String code, Object ... args) {
        return SpringContextHolder.getMessage(code, args);
    }

    protected void addFlashMessage(RedirectAttributes redirectAttributes, ResponseData responseData) {
        if (redirectAttributes != null && responseData != null) {
            redirectAttributes.addFlashAttribute(FLASH_MESSAGE, (Object)responseData);
        }
    }
}

