/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.common.utils;

import com.cpi.framework.core.spring.SpringContextHolder;
import com.cpi.framework.web.common.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static Properties properties = new Properties();

    public static String getProperty(String propertyName) {
        return properties.getProperty(propertyName);
    }

    public static boolean isValid(MultipartFile multipartFile) {
        return FilenameUtils.isExtension((String)multipartFile.getOriginalFilename(), (String[])FileInfo.FileType.getFileExts());
    }

    public static boolean multiFileUpload(HttpServletRequest request, String targetPath) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator ite = multiRequest.getFileNames();
            while (ite.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)ite.next());
                if (file == null) continue;
                File localFile = new File((targetPath.endsWith("/") ? targetPath : targetPath + "/") + file.getOriginalFilename());
                try {
                    file.transferTo(localFile);
                }
                catch (IllegalStateException e) {
                    logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u8bfb\u5199\u9519\u8bef!", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static String fileUpload(MultipartFile file, String targetPath) {
        File temp;
        targetPath = properties.getProperty("upload.file.path") + "\\" + targetPath + "\\";
        String fileName = file.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String lastFileName = UUID.randomUUID().toString() + suffix;
        if (!targetPath.endsWith(File.separator)) {
            targetPath = targetPath + File.separator;
        }
        if (!(temp = new File(targetPath)).exists() || !temp.isDirectory()) {
            temp.mkdirs();
        }
        String fileFullPath = targetPath + lastFileName;
        try {
            FileCopyUtils.copy((byte[])file.getBytes(), (File)new File(fileFullPath));
            return lastFileName;
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u5199\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(String fileName, String filePath, HttpServletResponse response) throws IOException {
        fileName = URLEncoder.encode(fileName, "UTF-8");
        File file = new File(properties.getProperty("upload.file.path") + "\\" + filePath);
        response.setContentType("MediaType.APPLICATION_OCTET_STREAM;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        FileInputStream in = null;
        ServletOutputStream servletOutputStream = null;
        try {
            int length;
            in = new FileInputStream(file);
            servletOutputStream = response.getOutputStream();
            int size = 1024;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, length);
            }
        }
        finally {
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(String filePath, HttpServletResponse response) throws IOException {
        File file = new File(filePath);
        String fileName = URLEncoder.encode(file.getName(), "UTF-8");
        response.setContentType("MediaType.APPLICATION_OCTET_STREAM;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        FileInputStream in = null;
        ServletOutputStream servletOutputStream = null;
        try {
            int length;
            in = new FileInputStream(file);
            servletOutputStream = response.getOutputStream();
            int size = 1024;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                servletOutputStream.write(buffer, 0, length);
            }
        }
        finally {
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
    }

    static {
        try {
            String[] postProcessorNames;
            for (String ppName : postProcessorNames = SpringContextHolder.getApplicationContext().getBeanNamesForType(BeanFactoryPostProcessor.class, true, true)) {
                BeanFactoryPostProcessor beanProcessor = SpringContextHolder.getBean(ppName, BeanFactoryPostProcessor.class);
                if (!(beanProcessor instanceof PropertyResourceConfigurer)) continue;
                PropertyResourceConfigurer propertyResourceConfigurer = (PropertyResourceConfigurer)beanProcessor;
                Method mergeProperties = PropertiesLoaderSupport.class.getDeclaredMethod("mergeProperties", new Class[0]);
                mergeProperties.setAccessible(true);
                Properties props = (Properties)mergeProperties.invoke((Object)propertyResourceConfigurer, new Object[0]);
                Method convertProperties = PropertyResourceConfigurer.class.getDeclaredMethod("convertProperties", Properties.class);
                convertProperties.setAccessible(true);
                convertProperties.invoke((Object)propertyResourceConfigurer, props);
                properties.putAll((Map<?, ?>)props);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

