/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.common.mybatis.page;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReflectHelper {
    public static Field getFieldByFieldName(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object getValueByFieldName(Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectHelper.getFieldByFieldName(obj, fieldName);
        Object value = null;
        if (field != null) {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        return value;
    }

    public static void setValueByFieldName(Object obj, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        if (field.isAccessible()) {
            field.set(obj, value);
        } else {
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(false);
        }
    }

    public static void setValueByFileNameSup(Object obj, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = obj.getClass().getSuperclass().getDeclaredField(fieldName);
        if (field.isAccessible()) {
            field.set(obj, value);
        } else {
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(false);
        }
    }

    public static Object invoke(Class runClass, String method, Object[] params) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        Object reObj = null;
        Object obj = runClass.newInstance();
        Method ms = runClass.getMethod(method, ReflectHelper.transformObjectParameter(params));
        ms.setAccessible(true);
        reObj = ms.invoke(obj, params);
        ms.setAccessible(false);
        return reObj;
    }

    public static Object getPropertyByProprtyName(Object object, String fieldName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String getter = "get" + firstLetter + fieldName.substring(1);
        Method method = object.getClass().getMethod(getter, new Class[0]);
        method.setAccessible(true);
        Object value = method.invoke(object, new Object[0]);
        method.setAccessible(false);
        return value;
    }

    public static Object setPropertyByProprtyName(Object object, String fieldName, Object[] params) {
        Object reObj = null;
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "set" + firstLetter + fieldName.substring(1);
            Method method = object.getClass().getMethod(getter, ReflectHelper.transformObjectParameter(params));
            method.setAccessible(true);
            reObj = method.invoke(object, params);
            method.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reObj;
    }

    private static Class[] transformObjectParameter(Object[] m_gwParameter) {
        Class[] res = null;
        if (m_gwParameter == null || m_gwParameter.length < 1) {
            return res;
        }
        res = new Class[m_gwParameter.length];
        for (int i = 0; i < m_gwParameter.length; ++i) {
            res[i] = Integer.class.isInstance(m_gwParameter[i]) ? Integer.TYPE : (Byte.class.isInstance(m_gwParameter[i]) ? Byte.TYPE : (Short.class.isInstance(m_gwParameter[i]) ? Short.TYPE : (HashMap.class.isInstance(m_gwParameter[i]) ? Map.class : (ArrayList.class.isInstance(m_gwParameter[i]) ? List.class : (m_gwParameter[i] == null ? null : m_gwParameter[i].getClass())))));
        }
        return res;
    }
}

