/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.utils;

import com.cpi.framework.modules.mapper.EnumConverter;
import com.cpi.framework.modules.utils.DateUtils;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.springframework.util.Assert;

public final class FreemarkerUtils {
    private static final ConvertUtilsBean convertUtils = new ConvertUtilsBean(){

        public String convert(Object value) {
            if (value != null) {
                Class<?> type = value.getClass();
                if (type.isEnum() && super.lookup(type) == null) {
                    super.register((Converter)new EnumConverter(type), type);
                } else if (type.isArray() && type.getComponentType().isEnum()) {
                    if (super.lookup(type) == null) {
                        ArrayConverter arrayConverter = new ArrayConverter(type, (Converter)new EnumConverter(type.getComponentType()), 0);
                        arrayConverter.setOnlyFirstToString(false);
                        super.register((Converter)arrayConverter, type);
                    }
                    Converter converter = super.lookup(type);
                    return (String)converter.convert(String.class, value);
                }
            }
            return super.convert(value);
        }

        public Object convert(String value, Class clazz) {
            if (clazz.isEnum() && super.lookup(clazz) == null) {
                super.register((Converter)new EnumConverter(clazz), clazz);
            }
            return super.convert(value, clazz);
        }

        public Object convert(String[] values, Class clazz) {
            if (clazz.isArray() && clazz.getComponentType().isEnum() && super.lookup(clazz.getComponentType()) == null) {
                super.register((Converter)new EnumConverter(clazz.getComponentType()), clazz.getComponentType());
            }
            return super.convert(values, clazz);
        }

        public Object convert(Object value, Class targetType) {
            if (super.lookup(targetType) == null) {
                if (targetType.isEnum()) {
                    super.register((Converter)new EnumConverter(targetType), targetType);
                } else if (targetType.isArray() && targetType.getComponentType().isEnum()) {
                    ArrayConverter arrayConverter = new ArrayConverter(targetType, (Converter)new EnumConverter(targetType.getComponentType()), 0);
                    arrayConverter.setOnlyFirstToString(false);
                    super.register((Converter)arrayConverter, targetType);
                }
            }
            return super.convert(value, targetType);
        }
    };
    private static final String prefix = "WEB-INF/template";

    private FreemarkerUtils() {
    }

    public static String process(String template, Map<String, ?> model) throws IOException, TemplateException {
        Configuration configuration = new Configuration();
        return FreemarkerUtils.process(template, model, configuration);
    }

    public static String process(String template, Map<String, ?> model, Configuration configuration) throws IOException, TemplateException {
        if (template == null) {
            return null;
        }
        if (configuration == null) {
            configuration = new Configuration();
        }
        StringWriter out = new StringWriter();
        new Template("template", (Reader)new StringReader(template), configuration).process(model, (Writer)out);
        return out.toString();
    }

    public static <T> T getParameter(String name, Class<T> type, Map<String, TemplateModel> params) throws TemplateModelException {
        Assert.hasText((String)name);
        Assert.notNull(type);
        Assert.notNull(params);
        TemplateModel templateModel = params.get(name);
        if (templateModel == null) {
            return null;
        }
        Object value = DeepUnwrap.unwrap((TemplateModel)templateModel);
        return (T)convertUtils.convert(value, type);
    }

    public static TemplateModel getVariable(String name, Environment env) throws TemplateModelException {
        Assert.hasText((String)name);
        Assert.notNull((Object)env);
        return env.getVariable(name);
    }

    public static void setVariable(String name, Object value, Environment env) throws TemplateException {
        Assert.hasText((String)name);
        Assert.notNull((Object)env);
        if (value instanceof TemplateModel) {
            env.setVariable(name, (TemplateModel)value);
        } else {
            env.setVariable(name, ObjectWrapper.BEANS_WRAPPER.wrap(value));
        }
    }

    public static void setVariables(Map<String, Object> variables, Environment env) throws TemplateException {
        Assert.notNull(variables);
        Assert.notNull((Object)env);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof TemplateModel) {
                env.setVariable(name, (TemplateModel)value);
                continue;
            }
            env.setVariable(name, ObjectWrapper.BEANS_WRAPPER.wrap(value));
        }
    }

    public static <T> void generFile(Map<String, Object> dataMap, OutputStream outStream, String templateFileName, ServletContext context) throws IOException, TemplateException {
        Configuration config = new Configuration();
        config.setDefaultEncoding("UTF-8");
        config.setServletContextForTemplateLoading((Object)context, prefix);
        Template t = config.getTemplate(templateFileName);
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream, "UTF-8");
        t.process(dataMap, (Writer)outWriter);
        outWriter.flush();
        outWriter.close();
    }

    static {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setPatterns(DateUtils.parsePatterns);
        convertUtils.register((Converter)dateConverter, Date.class);
    }
}

