/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateUtils {
    public static final String[] parsePatterns = new String[]{"yyyy/MM/dd", "yyyy-MM-dd", "yyyy-M-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy\u5e74MM\u6708", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM"};

    public static Date parseDate(String dateStr) throws ParseException {
        return org.apache.commons.lang.time.DateUtils.parseDate((String)dateStr, (String[])parsePatterns);
    }

    public static boolean isValidDate(String date) {
        if (date == null || date.length() < 8) {
            return false;
        }
        try {
            String[] format;
            boolean result = false;
            char dateSpace = date.charAt(4);
            if (dateSpace == '-' || dateSpace == '/') {
                format = new String[4];
                String strDateSpace = Character.toString(dateSpace);
                format[0] = "yyyy" + strDateSpace + "MM" + strDateSpace + "dd";
                format[1] = "yyyy" + strDateSpace + "MM" + strDateSpace + "d";
                format[2] = "yyyy" + strDateSpace + "M" + strDateSpace + "dd";
                format[3] = "yyyy" + strDateSpace + "M" + strDateSpace + "d";
            } else {
                format = new String[]{"yyyyMMdd"};
            }
            for (int i = 0; i < format.length; ++i) {
                String aFormat = format[i];
                SimpleDateFormat formatter = new SimpleDateFormat(aFormat);
                formatter.setLenient(false);
                String tmp = formatter.format(formatter.parse(date));
                if (!date.equals(tmp)) continue;
                result = true;
                break;
            }
            return result;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidTime(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formatter.setLenient(false);
            formatter.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date parseString(String date, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        return formatter.parse(formatter.format(DateUtils.parseDate(date)));
    }

    public static Date formatDate(Date date, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        return formatter.parse(formatter.format(date));
    }

    public static String parseDate(Date date, String formatType) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        return formatter.format(date);
    }

    public static String formatString(String date, String formatType) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        return formatter.format(DateUtils.parseDate(date));
    }

    public static Date parseString(String dateStr) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74M\u6708");
        return format.parse(dateStr);
    }

    public static Date strToDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date yyyyMDstrToDate(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/M/d");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTimeH(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static Date strToTime(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setLenient(false);
        return formatter.parse(date);
    }

    public static String dateToMonthStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        return formatter.format(date);
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static String timeToStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(date);
    }

    public static Date getNowDate() {
        return new java.sql.Date(new Date().getTime());
    }

    public static String getDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String getNow() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static String formatDate(Date time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74M\u6708");
        return formatter.format(time);
    }

    public static String getTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date Now = new Date();
        return formatter.format(Now);
    }

    public static int getYear() {
        Date Now = new Date();
        return DateUtils.getYear(Now);
    }

    public static int getMonth() {
        Date Now = new Date();
        return DateUtils.getMonth(Now);
    }

    public static int getYear(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        return Integer.parseInt(formatter.format(date));
    }

    public static int getMonth(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("M");
        return Integer.parseInt(formatter.format(date));
    }

    public static String getMonthFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-01");
        return formatter.format(date);
    }

    public static String getYearFirstDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-01-01");
        return formatter.format(date);
    }

    public static String getYearMaxDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-12-31");
        return formatter.format(date);
    }

    public static int getDay() {
        Date Now = new Date();
        return DateUtils.getDay(Now);
    }

    public static int getDay(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("d");
        return Integer.parseInt(formatter.format(date));
    }

    public static Date addDay(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(5, addCount);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int addCount) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.strToDate(DateUtils.dateToStr(date)));
        calendar.add(2, addCount);
        return calendar.getTime();
    }

    public static Date getCurWeekBegin() {
        Calendar cal = Calendar.getInstance();
        int day_of_week = cal.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        cal.add(5, -day_of_week + 1);
        return cal.getTime();
    }

    public static Date getCurWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getCurWeekBegin());
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getPriorWeekBegin() {
        Calendar cal = Calendar.getInstance();
        int day_of_week = cal.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        cal.add(5, -day_of_week - 7 + 1);
        return cal.getTime();
    }

    public static Date getPriorWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getPriorWeekBegin());
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getWeekBeginByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day_of_week = cal.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        cal.add(5, -day_of_week + 1);
        return cal.getTime();
    }

    public static Date getWeekEndByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getWeekBeginByDate(date));
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getPriorWeekBeginByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day_of_week = cal.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        cal.add(5, -day_of_week - 7 + 1);
        return cal.getTime();
    }

    public static Date getPriorWeekEndByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getPriorWeekBeginByDate(date));
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getPriorMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        return cal.getTime();
    }

    public static Date getPriorMonthByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        return cal.getTime();
    }

    public static Date getMonthMinTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getMonthMaxTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int maxDay = cal.getActualMaximum(5);
        cal.set(5, maxDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getDateMinTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDateMaxTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Integer dayCount(Date dateEnd, Date dateStart) {
        long time = dateEnd.getTime() - dateStart.getTime();
        long num = time / 86400000L;
        return Integer.parseInt(String.valueOf(num));
    }

    public static int getMonthBetweenDate(Date beginDate, Date endDate) throws ParseException {
        Calendar calbegin = Calendar.getInstance();
        Calendar calend = Calendar.getInstance();
        calbegin.setTime(beginDate);
        calend.setTime(endDate);
        int m_begin = calbegin.get(2) + 1;
        int m_end = calend.get(2) + 1;
        int checkmonth = m_end - m_begin + (calend.get(1) - calbegin.get(1)) * 12;
        return checkmonth;
    }

    public static int getMonthWorkDays(Date curDate) {
        int count = 0;
        Date endDate = DateUtils.getMonthMaxTime(curDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(curDate);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        while (cal.getTime().before(endDate)) {
            int day = cal.get(7);
            if (day != 1 && day != 7) {
                ++count;
            }
            cal.add(5, 1);
        }
        return count;
    }
}

