/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.security.shiro;

import com.cpi.framework.modules.security.shiro.FwAuthenticationToken;
import com.cpi.framework.modules.utils.JSONUtil;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.common.utils.AjaxUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FwFormAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FwFormAuthenticationFilter.class);
    private static final String DEFAULT_CAPTCHA_ID_PARAM = "captchaId";
    private static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    private static final String DEFAULT_COMPANY_ID_PARAM = "companyId";
    private String captchaIdParam = "captchaId";
    private String captchaParam = "captcha";
    private String companyIdParam = "companyId";

    protected AuthenticationToken createToken(ServletRequest servletRequest, ServletResponse servletResponse) {
        String username = this.getUsername(servletRequest);
        String password = this.getPassword(servletRequest);
        boolean rememberMe = this.isRememberMe(servletRequest);
        String captchaId = this.getCaptchaId(servletRequest);
        String captcha = this.getCaptcha(servletRequest);
        Long companyId = this.getCompanyId(servletRequest);
        return new FwAuthenticationToken(username, password, captchaId, captcha, rememberMe, companyId);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (AjaxUtil.isAjaxRequest((HttpServletRequest)servletRequest)) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            response.setCharacterEncoding("UTF-8");
            PrintWriter out = response.getWriter();
            out.println(JSONUtil.toJSon(ResponseData.SUCCESS_NO_DATA));
            out.flush();
            out.close();
            return false;
        }
        return super.onLoginSuccess(token, subject, servletRequest, servletResponse);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest servletRequest, ServletResponse servletResponse) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (AjaxUtil.isAjaxRequest(request)) {
            try {
                response.setCharacterEncoding("UTF-8");
                PrintWriter out = response.getWriter();
                String message = e.getClass().getSimpleName();
                if ("IncorrectCredentialsException".equals(message)) {
                    out.println(JSONUtil.toJSon(ResponseData.error("\u5bc6\u7801\u9519\u8bef")));
                } else if ("UnknownAccountException".equals(message)) {
                    out.println(JSONUtil.toJSon(ResponseData.error("\u8d26\u53f7\u4e0d\u5b58\u5728")));
                } else if ("LockedAccountException".equals(message)) {
                    out.println(JSONUtil.toJSon(ResponseData.error("\u8d26\u53f7\u88ab\u9501\u5b9a")));
                } else {
                    out.println(JSONUtil.toJSon(ResponseData.error("\u672a\u77e5\u9519\u8bef")));
                }
                out.flush();
                out.close();
            }
            catch (IOException ioe) {
                LOGGER.error(ioe.getMessage());
            }
            return false;
        }
        return super.onLoginFailure(token, e, (ServletRequest)request, (ServletResponse)response);
    }

    protected boolean onAccessDenied(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (AjaxUtil.isAjaxRequest(request)) {
            response.setCharacterEncoding("UTF-8");
            response.addHeader("loginStatus", "accessDenied");
            response.sendError(403);
            return false;
        }
        return super.onAccessDenied((ServletRequest)request, (ServletResponse)response);
    }

    protected String getCaptchaId(ServletRequest servletRequest) {
        String captchaId = WebUtils.getCleanParam((ServletRequest)servletRequest, (String)this.captchaIdParam);
        if (captchaId == null) {
            captchaId = ((HttpServletRequest)servletRequest).getSession().getId();
        }
        return captchaId;
    }

    protected String getCaptcha(ServletRequest servletRequest) {
        return WebUtils.getCleanParam((ServletRequest)servletRequest, (String)this.captchaParam);
    }

    protected Long getCompanyId(ServletRequest servletRequest) {
        String companyId = WebUtils.getCleanParam((ServletRequest)servletRequest, (String)this.companyIdParam);
        return StringUtils.isNotBlank((String)companyId) ? Long.valueOf(companyId) : null;
    }

    public String getCaptchaIdParam() {
        return this.captchaIdParam;
    }

    public void setCaptchaIdParam(String captchaIdParam) {
        this.captchaIdParam = captchaIdParam;
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    public String getCompanyIdParam() {
        return this.companyIdParam;
    }

    public void setCompanyIdParam(String companyIdParam) {
        this.companyIdParam = companyIdParam;
    }
}

