/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.dao.support;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Pageable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pagination<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> result = new ArrayList<T>();
    private Map<String, Object> attMap = new HashMap<String, Object>();
    private final long total;
    private final Pageable pageable;

    public Pagination() {
        this.total = 0L;
        this.pageable = new Pageable();
    }

    public Pagination(List<T> content, long total, Pageable pageable) {
        this.result.addAll(content);
        this.total = total;
        this.pageable = pageable;
    }

    public Map<String, Object> getAttMap() {
        return this.attMap;
    }

    public void setAttMap(Map<String, Object> attMap) {
        this.attMap = attMap;
    }

    public void addAttMap(String key, String value) {
        this.attMap.put(key, value);
    }

    @JsonIgnore
    public int getPageNumber() {
        return this.pageable.getPageNumber();
    }

    @JsonIgnore
    public int getPageSize() {
        return this.pageable.getPageSize();
    }

    @JsonIgnore
    public String getSearchProperty() {
        return this.pageable.getSearchProperty();
    }

    @JsonIgnore
    public String getSearchValue() {
        return this.pageable.getSearchValue();
    }

    @JsonIgnore
    public String getOrderProperty() {
        return this.pageable.getOrderProperty();
    }

    @JsonIgnore
    public Order.Direction getOrderDirection() {
        return this.pageable.getOrderDirection();
    }

    @JsonIgnore
    public List<Order> getOrders() {
        return this.pageable.getOrders();
    }

    @JsonIgnore
    public List<Filter> getFilters() {
        return this.pageable.getFilters();
    }

    @JsonIgnore
    public int getTotalPages() {
        return (int)Math.ceil((double)this.getTotal() / (double)this.getPageSize());
    }

    @JsonProperty(value="rows")
    public List<T> getResult() {
        return this.result;
    }

    @JsonProperty(value="total")
    public long getTotal() {
        return this.total;
    }

    @JsonIgnore
    public Pageable getPageable() {
        return this.pageable;
    }
}

