/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.dao.jpa.impl;

import com.cpi.framework.dao.jpa.IBaseDao;
import com.cpi.framework.dao.model.SortEntity;
import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public abstract class BaseDaoImpl<T, ID extends Serializable>
implements IBaseDao<T, ID> {
    private Class<T> entityClass;
    private static volatile long aliasCount = 0L;
    @PersistenceContext
    protected EntityManager entityManager;

    public BaseDaoImpl() {
        Type type = this.getClass().getGenericSuperclass();
        Type[] parameterizedType = ((ParameterizedType)type).getActualTypeArguments();
        this.entityClass = (Class)parameterizedType[0];
    }

    @Override
    public T getReference(ID id) {
        if (id != null) {
            return (T)this.entityManager.getReference(this.entityClass, id);
        }
        return null;
    }

    @Override
    public T find(ID id) {
        if (id != null) {
            return (T)this.entityManager.find(this.entityClass, id);
        }
        return null;
    }

    @Override
    public T find(ID id, LockModeType lockModeType) {
        if (id != null) {
            if (lockModeType != null) {
                return (T)this.entityManager.find(this.entityClass, id, lockModeType);
            }
            return (T)this.entityManager.find(this.entityClass, id);
        }
        return null;
    }

    @Override
    public List<T> findList(Integer first, Integer count, List<Filter> filters, List<com.cpi.framework.dao.support.Order> orders) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        criteriaQuery.select((Selection)criteriaQuery.from(this.entityClass));
        return this.findList(criteriaQuery, first, count, filters, orders);
    }

    @Override
    public Pagination<T> findPage(Pageable pageable) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        criteriaQuery.select((Selection)criteriaQuery.from(this.entityClass));
        return this.findPage(criteriaQuery, pageable);
    }

    @Override
    public long count(Filter ... filters) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        criteriaQuery.select((Selection)criteriaQuery.from(this.entityClass));
        return this.count(criteriaQuery, filters != null ? Arrays.asList(filters) : null);
    }

    @Override
    public void persist(T entity) {
        Assert.notNull(entity);
        this.entityManager.persist(entity);
    }

    @Override
    public T merge(T entity) {
        Assert.notNull(entity);
        return (T)this.entityManager.merge(entity);
    }

    @Override
    public void batchPersist(List<T> entitys) {
        for (int i = 0; i < entitys.size(); ++i) {
            this.entityManager.persist(entitys.get(i));
            if (i % 30 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }

    @Override
    public void batchMerge(List<T> entitys) {
        for (int i = 0; i < entitys.size(); ++i) {
            this.entityManager.merge(entitys.get(i));
            if (i % 30 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }

    @Override
    public void remove(T entity) {
        if (entity != null) {
            this.entityManager.remove(entity);
        }
    }

    @Override
    public void refresh(T entity) {
        if (entity != null) {
            this.entityManager.refresh(entity);
        }
    }

    @Override
    public void refresh(T entity, LockModeType lockModeType) {
        if (entity != null) {
            if (lockModeType != null) {
                this.entityManager.refresh(entity, lockModeType);
            } else {
                this.entityManager.refresh(entity);
            }
        }
    }

    @Override
    public ID getIdentifier(T entity) {
        Assert.notNull(entity);
        return (ID)((Serializable)this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(entity));
    }

    @Override
    public boolean isManaged(T entity) {
        return this.entityManager.contains(entity);
    }

    @Override
    public void detach(T entity) {
        this.entityManager.detach(entity);
    }

    @Override
    public void lock(T entity, LockModeType lockModeType) {
        if (entity != null && lockModeType != null) {
            this.entityManager.lock(entity, lockModeType);
        }
    }

    @Override
    public void clear() {
        this.entityManager.clear();
    }

    @Override
    public void flush() {
        this.entityManager.flush();
    }

    protected List<T> findList(CriteriaQuery<T> criteriaQuery, Integer first, Integer count, List<Filter> filters, List<com.cpi.framework.dao.support.Order> orders) {
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Root<T> root = this.getRoot(criteriaQuery);
        this.addRestrictions(criteriaQuery, filters);
        this.addOrders(criteriaQuery, orders);
        if (criteriaQuery.getOrderList().isEmpty()) {
            if (SortEntity.class.isAssignableFrom(this.entityClass)) {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("orderNo"))});
            } else {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("createDate"))});
            }
        }
        TypedQuery query = this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        if (first != null) {
            query.setFirstResult(first.intValue());
        }
        if (count != null) {
            query.setMaxResults(count.intValue());
        }
        return query.getResultList();
    }

    protected Pagination<T> findPage(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        long total;
        int totalPages;
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        if (pageable == null) {
            pageable = new Pageable();
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Root<T> root = this.getRoot(criteriaQuery);
        this.addRestrictions(criteriaQuery, pageable);
        this.addOrders(criteriaQuery, pageable);
        if (criteriaQuery.getOrderList().isEmpty()) {
            if (SortEntity.class.isAssignableFrom(this.entityClass)) {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("orderNo"))});
            } else {
                criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("createDate"))});
            }
        }
        if ((totalPages = (int)Math.ceil((double)(total = this.count(criteriaQuery, null).longValue()) / (double)pageable.getPageSize())) < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        TypedQuery query = this.entityManager.createQuery(criteriaQuery).setFlushMode(FlushModeType.COMMIT);
        query.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        return new Pagination(query.getResultList(), total, pageable);
    }

    protected Long count(CriteriaQuery<T> criteriaQuery, List<Filter> filters) {
        Assert.notNull(criteriaQuery);
        Assert.notNull((Object)criteriaQuery.getSelection());
        Assert.notEmpty((Collection)criteriaQuery.getRoots());
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        this.addRestrictions(criteriaQuery, filters);
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(Long.class);
        for (Root root : criteriaQuery.getRoots()) {
            Root dest = countCriteriaQuery.from(root.getJavaType());
            dest.alias(this.getAlias((Selection<?>)root));
            this.copyJoins((From<?, ?>)root, (From<?, ?>)dest);
        }
        Root<T> countRoot = this.getRoot(countCriteriaQuery, criteriaQuery.getResultType());
        countCriteriaQuery.select((Selection)criteriaBuilder.count(countRoot));
        if (criteriaQuery.getGroupList() != null) {
            countCriteriaQuery.groupBy(criteriaQuery.getGroupList());
        }
        if (criteriaQuery.getGroupRestriction() != null) {
            countCriteriaQuery.having((Expression)criteriaQuery.getGroupRestriction());
        }
        if (criteriaQuery.getRestriction() != null) {
            countCriteriaQuery.where((Expression)criteriaQuery.getRestriction());
        }
        return (Long)this.entityManager.createQuery(countCriteriaQuery).setFlushMode(FlushModeType.COMMIT).getSingleResult();
    }

    private synchronized String getAlias(Selection<?> selection) {
        if (selection != null) {
            String alias = selection.getAlias();
            if (alias == null) {
                if (aliasCount >= 1000L) {
                    aliasCount = 0L;
                }
                alias = "fourdbGeneratedAlias" + aliasCount++;
                selection.alias(alias);
            }
            return alias;
        }
        return null;
    }

    private Root<T> getRoot(CriteriaQuery<T> criteriaQuery) {
        if (criteriaQuery != null) {
            return this.getRoot(criteriaQuery, criteriaQuery.getResultType());
        }
        return null;
    }

    private Root<T> getRoot(CriteriaQuery<?> criteriaQuery, Class<T> clazz) {
        if (criteriaQuery != null && criteriaQuery.getRoots() != null && clazz != null) {
            for (Root root : criteriaQuery.getRoots()) {
                if (!clazz.equals(root.getJavaType())) continue;
                return (Root)root.as(clazz);
            }
        }
        return null;
    }

    private void copyJoins(From<?, ?> from, From<?, ?> to) {
        for (Join join : from.getJoins()) {
            Join toJoin = to.join(join.getAttribute().getName(), join.getJoinType());
            toJoin.alias(this.getAlias((Selection<?>)join));
            this.copyJoins((From<?, ?>)join, (From<?, ?>)toJoin);
        }
        for (Fetch fetch : from.getFetches()) {
            Fetch toFetch = to.fetch(fetch.getAttribute().getName());
            this.copyFetches(fetch, toFetch);
        }
    }

    private void copyFetches(Fetch<?, ?> from, Fetch<?, ?> to) {
        for (Fetch fetch : from.getFetches()) {
            Fetch toFetch = to.fetch(fetch.getAttribute().getName());
            this.copyFetches(fetch, toFetch);
        }
    }

    private void addRestrictions(CriteriaQuery<T> criteriaQuery, List<Filter> filters) {
        if (criteriaQuery == null || filters == null || filters.isEmpty()) {
            return;
        }
        Root<T> root = this.getRoot(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Predicate restrictions = criteriaQuery.getRestriction() != null ? criteriaQuery.getRestriction() : criteriaBuilder.conjunction();
        for (Filter filter : filters) {
            if (filter == null || StringUtils.isEmpty((String)filter.getProperty())) continue;
            if (filter.getOperator() == Filter.Operator.eq && filter.getValue() != null) {
                if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                    continue;
                }
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get(filter.getProperty()), filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.ne && filter.getValue() != null) {
                if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.notEqual(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                    continue;
                }
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.notEqual((Expression)root.get(filter.getProperty()), filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.gt && filter.getValue() != null) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.gt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.lt && filter.getValue() != null) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.lt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.ge && filter.getValue() != null) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.ge((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.le && filter.getValue() != null) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.le((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.like && filter.getValue() != null && filter.getValue() instanceof String) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.like((Expression)root.get(filter.getProperty()), (String)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.in && filter.getValue() != null) {
                if (filter.getValue() instanceof Collection) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in((Collection)filter.getValue()));
                    continue;
                }
                if (filter.getValue().getClass().isArray()) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in((Object[])filter.getValue()));
                    continue;
                }
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in(new Object[]{filter.getValue()}));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.isNull) {
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).isNull());
                continue;
            }
            if (filter.getOperator() != Filter.Operator.isNotNull) continue;
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).isNotNull());
        }
        criteriaQuery.where((Expression)restrictions);
    }

    private void addRestrictions(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        Predicate restrictions;
        if (criteriaQuery == null || pageable == null) {
            return;
        }
        Root<T> root = this.getRoot(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Predicate predicate = restrictions = criteriaQuery.getRestriction() != null ? criteriaQuery.getRestriction() : criteriaBuilder.conjunction();
        if (StringUtils.isNotEmpty((String)pageable.getSearchProperty()) && StringUtils.isNotEmpty((String)pageable.getSearchValue())) {
            restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.like((Expression)root.get(pageable.getSearchProperty()), "%" + pageable.getSearchValue() + "%"));
        }
        if (pageable.getFilters() != null) {
            for (Filter filter : pageable.getFilters()) {
                if (filter == null || StringUtils.isEmpty((String)filter.getProperty())) continue;
                if (filter.getOperator() == Filter.Operator.eq && filter.getValue() != null) {
                    if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                        continue;
                    }
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.equal((Expression)root.get(filter.getProperty()), filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.ne && filter.getValue() != null) {
                    if (filter.getIgnoreCase() != null && filter.getIgnoreCase().booleanValue() && filter.getValue() instanceof String) {
                        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.notEqual(criteriaBuilder.lower((Expression)root.get(filter.getProperty())), (Object)((String)filter.getValue()).toLowerCase()));
                        continue;
                    }
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.notEqual((Expression)root.get(filter.getProperty()), filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.gt && filter.getValue() != null) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.gt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.lt && filter.getValue() != null) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.lt((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.ge && filter.getValue() != null) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.ge((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.le && filter.getValue() != null) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.le((Expression)root.get(filter.getProperty()), (Number)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.like && filter.getValue() != null && filter.getValue() instanceof String) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)criteriaBuilder.like((Expression)root.get(filter.getProperty()), (String)filter.getValue()));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.in && filter.getValue() != null) {
                    if (filter.getValue() instanceof Collection) {
                        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in((Collection)filter.getValue()));
                        continue;
                    }
                    if (filter.getValue().getClass().isArray()) {
                        restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in((Object[])filter.getValue()));
                        continue;
                    }
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).in(new Object[]{filter.getValue()}));
                    continue;
                }
                if (filter.getOperator() == Filter.Operator.isNull) {
                    restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).isNull());
                    continue;
                }
                if (filter.getOperator() != Filter.Operator.isNotNull) continue;
                restrictions = criteriaBuilder.and((Expression)restrictions, (Expression)root.get(filter.getProperty()).isNotNull());
            }
        }
        criteriaQuery.where((Expression)restrictions);
    }

    private void addOrders(CriteriaQuery<T> criteriaQuery, List<com.cpi.framework.dao.support.Order> orders) {
        if (criteriaQuery == null || orders == null || orders.isEmpty()) {
            return;
        }
        Root<T> root = this.getRoot(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (!criteriaQuery.getOrderList().isEmpty()) {
            orderList.addAll(criteriaQuery.getOrderList());
        }
        for (com.cpi.framework.dao.support.Order order : orders) {
            if (order.getDirection() == Order.Direction.asc) {
                orderList.add(criteriaBuilder.asc((Expression)root.get(order.getProperty())));
                continue;
            }
            if (order.getDirection() != Order.Direction.desc) continue;
            orderList.add(criteriaBuilder.desc((Expression)root.get(order.getProperty())));
        }
        criteriaQuery.orderBy(orderList);
    }

    private void addOrders(CriteriaQuery<T> criteriaQuery, Pageable pageable) {
        if (criteriaQuery == null || pageable == null) {
            return;
        }
        Root<T> root = this.getRoot(criteriaQuery);
        if (root == null) {
            return;
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (!criteriaQuery.getOrderList().isEmpty()) {
            orderList.addAll(criteriaQuery.getOrderList());
        }
        if (StringUtils.isNotEmpty((String)pageable.getOrderProperty()) && pageable.getOrderDirection() != null) {
            if (pageable.getOrderDirection() == Order.Direction.asc) {
                orderList.add(criteriaBuilder.asc((Expression)root.get(pageable.getOrderProperty())));
            } else if (pageable.getOrderDirection() == Order.Direction.desc) {
                orderList.add(criteriaBuilder.desc((Expression)root.get(pageable.getOrderProperty())));
            }
        }
        if (pageable.getOrders() != null) {
            for (com.cpi.framework.dao.support.Order order : pageable.getOrders()) {
                if (order.getDirection() == Order.Direction.asc) {
                    orderList.add(criteriaBuilder.asc((Expression)root.get(order.getProperty())));
                    continue;
                }
                if (order.getDirection() != Order.Direction.desc) continue;
                orderList.add(criteriaBuilder.desc((Expression)root.get(order.getProperty())));
            }
        }
        criteriaQuery.orderBy(orderList);
    }

    @Override
    public List<T> findByJPQL(String queryString) {
        return this.findByJPQL(queryString, null);
    }

    @Override
    public List<T> findByJPQL(String queryString, Object value) {
        return this.findByJPQL(queryString, new Object[]{value});
    }

    @Override
    public List<T> findByJPQL(String queryString, Object[] values) {
        TypedQuery query = this.entityManager.createQuery(queryString, this.entityClass).setFlushMode(FlushModeType.COMMIT);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query.getResultList();
    }

    @Override
    public int bulkUpdate(String queryString) {
        return this.bulkUpdate(queryString, null);
    }

    @Override
    public int bulkUpdate(String queryString, Object value) {
        return this.bulkUpdate(queryString, new Object[]{value});
    }

    @Override
    public int bulkUpdate(String queryString, Object[] values) {
        Query query = this.entityManager.createQuery(queryString).setFlushMode(FlushModeType.COMMIT);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query.executeUpdate();
    }

    @Override
    public Pagination<T> pagerJPQLList(String jpql, Object[] params, Pageable pageable) {
        Long total;
        int totalPages;
        String countSql = this.getSelectJPQL(jpql);
        TypedQuery countQuery = this.entityManager.createQuery(countSql, Long.class);
        TypedQuery query = this.entityManager.createQuery(jpql, this.entityClass);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                countQuery.setParameter(i, params[i]);
                query.setParameter(i, params[i]);
            }
        }
        if ((totalPages = (int)Math.ceil((double)(total = (Long)countQuery.setFlushMode(FlushModeType.COMMIT).getSingleResult()).longValue() / (double)pageable.getPageSize())) < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        List list = query.setFlushMode(FlushModeType.COMMIT).setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList();
        return new Pagination(list, total, pageable);
    }

    @Override
    public Pagination<T> pagerJPQLList(String jpql, Map<String, ?> params, Pageable pageable) {
        String countSql = this.getSelectJPQL(jpql);
        TypedQuery countQuery = this.entityManager.createQuery(countSql, Long.class);
        TypedQuery query = this.entityManager.createQuery(jpql, this.entityClass);
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            countQuery.setParameter(entry.getKey(), entry.getValue());
            query.setParameter(entry.getKey(), entry.getValue());
        }
        Long total = (Long)countQuery.setFlushMode(FlushModeType.COMMIT).getSingleResult();
        int totalPages = (int)Math.ceil((double)total.longValue() / (double)pageable.getPageSize());
        if (totalPages < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        List list = query.setFlushMode(FlushModeType.COMMIT).setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList();
        return new Pagination(list, total, pageable);
    }

    @Override
    public <E> Pagination<E> pagerJPQLList(String jpql, Class<E> clazz, Map<String, ?> params, Pageable pageable) {
        String countSql = this.getSelectJPQL(jpql);
        TypedQuery countQuery = this.entityManager.createQuery(countSql, Long.class);
        TypedQuery query = this.entityManager.createQuery(jpql, clazz);
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            countQuery.setParameter(entry.getKey(), entry.getValue());
            query.setParameter(entry.getKey(), entry.getValue());
        }
        Long total = (Long)countQuery.setFlushMode(FlushModeType.COMMIT).getSingleResult();
        int totalPages = (int)Math.ceil((double)total.longValue() / (double)pageable.getPageSize());
        if (totalPages < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        List list = query.setFlushMode(FlushModeType.COMMIT).setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList();
        return new Pagination(list, total, pageable);
    }

    public <E> Pagination<E> pagerBeanJPQLList(String jpql, Class<E> clazz, Map<String, ?> params, Pageable pageable) {
        String countSql = "select count(*) " + this.getFromJPQL(jpql);
        TypedQuery countQuery = this.entityManager.createQuery(countSql, Long.class);
        TypedQuery query = this.entityManager.createQuery(jpql, clazz);
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            countQuery.setParameter(entry.getKey(), entry.getValue());
            query.setParameter(entry.getKey(), entry.getValue());
        }
        Long total = (Long)countQuery.setFlushMode(FlushModeType.COMMIT).getSingleResult();
        int totalPages = (int)Math.ceil((double)total.longValue() / (double)pageable.getPageSize());
        if (totalPages < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        List list = query.setFlushMode(FlushModeType.COMMIT).setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList();
        return new Pagination(list, total, pageable);
    }

    private String getSelectJPQL(String jpql) {
        int posi = jpql.toLowerCase().indexOf("from");
        String select = jpql.substring(0, posi);
        String from = jpql.substring(posi);
        select = select.replaceFirst("(?i)select", "select count(");
        return select + ") " + from.replaceAll("(?i)join(\\s*|\t|\r|\n)fetch", "join");
    }

    private String getFromJPQL(String jpql) {
        int posi = jpql.toLowerCase().indexOf("from");
        jpql = jpql.substring(posi);
        return jpql.replaceAll("(?i)join(\\s*|\t|\r|\n)fetch", "join");
    }
}

