/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.core.spring;

import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.web.servlet.LocaleResolver;

public final class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext;

    private SpringContextHolder() {
    }

    public synchronized void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        SpringContextHolder.checkApplicationContext();
        return SpringContextHolder.getApplicationContext().getBeansOfType(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        Assert.hasText((String)name);
        Assert.notNull(clazz);
        SpringContextHolder.checkApplicationContext();
        return (T)applicationContext.getBean(name, clazz);
    }

    public static void cleanApplicationContext() {
        applicationContext = null;
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u672a\u6ce8\u5165,\u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder");
        }
    }

    public static String getMessage(String code, Object ... args) {
        LocaleResolver localeResolver = SpringContextHolder.getBean("localeResolver", LocaleResolver.class);
        Locale locale = localeResolver.resolveLocale(null);
        return applicationContext.getMessage(code, args, locale);
    }

    public void destroy() throws Exception {
        applicationContext = null;
    }
}

