/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.cron.CronExpression;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.scheduler.MisfireStrategyEnum;
import com.xxl.job.admin.core.scheduler.ScheduleTypeEnum;
import com.xxl.job.admin.core.thread.JobTriggerPoolHelper;
import com.xxl.job.admin.core.trigger.TriggerTypeEnum;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobScheduleHelper {
    private static Logger logger = LoggerFactory.getLogger(JobScheduleHelper.class);
    private static JobScheduleHelper instance = new JobScheduleHelper();
    public static final long PRE_READ_MS = 5000L;
    private Thread scheduleThread;
    private Thread ringThread;
    private volatile boolean scheduleThreadToStop = false;
    private volatile boolean ringThreadToStop = false;
    private static volatile Map<Integer, List<Integer>> ringData = new ConcurrentHashMap<Integer, List<Integer>>();

    public static JobScheduleHelper getInstance() {
        return instance;
    }

    public void start() {
        this.scheduleThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block44: {
                    try {
                        TimeUnit.MILLISECONDS.sleep(5000L - System.currentTimeMillis() % 1000L);
                    }
                    catch (InterruptedException e) {
                        if (JobScheduleHelper.this.scheduleThreadToStop) break block44;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>> init xxl-job admin scheduler success.");
                int preReadCount = (XxlJobAdminConfig.getAdminConfig().getTriggerPoolFastMax() + XxlJobAdminConfig.getAdminConfig().getTriggerPoolSlowMax()) * 20;
                while (!JobScheduleHelper.this.scheduleThreadToStop) {
                    long cost;
                    long start = System.currentTimeMillis();
                    Connection conn = null;
                    Boolean connAutoCommit = null;
                    Statement preparedStatement = null;
                    boolean preReadSuc = true;
                    try {
                        conn = XxlJobAdminConfig.getAdminConfig().getDataSource().getConnection();
                        connAutoCommit = conn.getAutoCommit();
                        conn.setAutoCommit(false);
                        preparedStatement = conn.prepareStatement("select * from xxl_job_lock where lock_name = 'schedule_lock' for update");
                        preparedStatement.execute();
                        long nowTime = System.currentTimeMillis();
                        List<XxlJobInfo> scheduleList = XxlJobAdminConfig.getAdminConfig().getXxlJobInfoDao().scheduleJobQuery(nowTime + 5000L, preReadCount);
                        if (scheduleList != null && scheduleList.size() > 0) {
                            for (XxlJobInfo jobInfo : scheduleList) {
                                if (nowTime > jobInfo.getTriggerNextTime() + 5000L) {
                                    logger.warn(">>>>>>>>>>> xxl-job, schedule misfire, jobId = " + jobInfo.getId());
                                    MisfireStrategyEnum misfireStrategyEnum = MisfireStrategyEnum.match(jobInfo.getMisfireStrategy(), MisfireStrategyEnum.DO_NOTHING);
                                    if (MisfireStrategyEnum.FIRE_ONCE_NOW == misfireStrategyEnum) {
                                        JobTriggerPoolHelper.trigger(jobInfo.getId(), TriggerTypeEnum.MISFIRE, -1, null, null, null);
                                        logger.debug(">>>>>>>>>>> xxl-job, schedule push trigger : jobId = " + jobInfo.getId());
                                    }
                                    JobScheduleHelper.this.refreshNextValidTime(jobInfo, new Date());
                                    continue;
                                }
                                if (nowTime > jobInfo.getTriggerNextTime()) {
                                    JobTriggerPoolHelper.trigger(jobInfo.getId(), TriggerTypeEnum.CRON, -1, null, null, null);
                                    logger.debug(">>>>>>>>>>> xxl-job, schedule push trigger : jobId = " + jobInfo.getId());
                                    JobScheduleHelper.this.refreshNextValidTime(jobInfo, new Date());
                                    if (jobInfo.getTriggerStatus() != 1 || nowTime + 5000L <= jobInfo.getTriggerNextTime()) continue;
                                    int ringSecond = (int)(jobInfo.getTriggerNextTime() / 1000L % 60L);
                                    JobScheduleHelper.this.pushTimeRing(ringSecond, jobInfo.getId());
                                    JobScheduleHelper.this.refreshNextValidTime(jobInfo, new Date(jobInfo.getTriggerNextTime()));
                                    continue;
                                }
                                int ringSecond = (int)(jobInfo.getTriggerNextTime() / 1000L % 60L);
                                JobScheduleHelper.this.pushTimeRing(ringSecond, jobInfo.getId());
                                JobScheduleHelper.this.refreshNextValidTime(jobInfo, new Date(jobInfo.getTriggerNextTime()));
                            }
                            for (XxlJobInfo jobInfo : scheduleList) {
                                XxlJobAdminConfig.getAdminConfig().getXxlJobInfoDao().scheduleUpdate(jobInfo);
                            }
                        } else {
                            preReadSuc = false;
                        }
                    }
                    catch (Exception e) {
                        if (!JobScheduleHelper.this.scheduleThreadToStop) {
                            logger.error(">>>>>>>>>>> xxl-job, JobScheduleHelper#scheduleThread error:{}", (Throwable)e);
                        }
                    }
                    finally {
                        block49: {
                            block48: {
                                if (conn != null) {
                                    block47: {
                                        block46: {
                                            try {
                                                conn.commit();
                                            }
                                            catch (SQLException e) {
                                                if (JobScheduleHelper.this.scheduleThreadToStop) break block46;
                                                logger.error(e.getMessage(), (Throwable)e);
                                            }
                                        }
                                        try {
                                            conn.setAutoCommit(connAutoCommit);
                                        }
                                        catch (SQLException e) {
                                            if (JobScheduleHelper.this.scheduleThreadToStop) break block47;
                                            logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    try {
                                        conn.close();
                                    }
                                    catch (SQLException e) {
                                        if (JobScheduleHelper.this.scheduleThreadToStop) break block48;
                                        logger.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                            if (null != preparedStatement) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (SQLException e) {
                                    if (JobScheduleHelper.this.scheduleThreadToStop) break block49;
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    if ((cost = System.currentTimeMillis() - start) >= 1000L) continue;
                    try {
                        TimeUnit.MILLISECONDS.sleep((preReadSuc ? 1000L : 5000L) - System.currentTimeMillis() % 1000L);
                    }
                    catch (InterruptedException e) {
                        if (JobScheduleHelper.this.scheduleThreadToStop) continue;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, JobScheduleHelper#scheduleThread stop");
            }
        });
        this.scheduleThread.setDaemon(true);
        this.scheduleThread.setName("xxl-job, admin JobScheduleHelper#scheduleThread");
        this.scheduleThread.start();
        this.ringThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobScheduleHelper.this.ringThreadToStop) {
                    block7: {
                        try {
                            TimeUnit.MILLISECONDS.sleep(1000L - System.currentTimeMillis() % 1000L);
                        }
                        catch (InterruptedException e) {
                            if (JobScheduleHelper.this.ringThreadToStop) break block7;
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        ArrayList<Integer> ringItemData = new ArrayList<Integer>();
                        int nowSecond = Calendar.getInstance().get(13);
                        for (int i = 0; i < 2; ++i) {
                            List<Integer> tmpData = ringData.remove((nowSecond + 60 - i) % 60);
                            if (tmpData == null) continue;
                            ringItemData.addAll(tmpData);
                        }
                        logger.debug(">>>>>>>>>>> xxl-job, time-ring beat : " + nowSecond + " = " + Arrays.asList(ringItemData));
                        if (ringItemData.size() <= 0) continue;
                        Iterator iterator = ringItemData.iterator();
                        while (iterator.hasNext()) {
                            int jobId = (Integer)iterator.next();
                            JobTriggerPoolHelper.trigger(jobId, TriggerTypeEnum.CRON, -1, null, null, null);
                        }
                        ringItemData.clear();
                    }
                    catch (Exception e) {
                        if (JobScheduleHelper.this.ringThreadToStop) continue;
                        logger.error(">>>>>>>>>>> xxl-job, JobScheduleHelper#ringThread error:{}", (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, JobScheduleHelper#ringThread stop");
            }
        });
        this.ringThread.setDaemon(true);
        this.ringThread.setName("xxl-job, admin JobScheduleHelper#ringThread");
        this.ringThread.start();
    }

    private void refreshNextValidTime(XxlJobInfo jobInfo, Date fromTime) throws Exception {
        Date nextValidTime = JobScheduleHelper.generateNextValidTime(jobInfo, fromTime);
        if (nextValidTime != null) {
            jobInfo.setTriggerLastTime(jobInfo.getTriggerNextTime());
            jobInfo.setTriggerNextTime(nextValidTime.getTime());
        } else {
            jobInfo.setTriggerStatus(0);
            jobInfo.setTriggerLastTime(0L);
            jobInfo.setTriggerNextTime(0L);
            logger.warn(">>>>>>>>>>> xxl-job, refreshNextValidTime fail for job: jobId={}, scheduleType={}, scheduleConf={}", new Object[]{jobInfo.getId(), jobInfo.getScheduleType(), jobInfo.getScheduleConf()});
        }
    }

    private void pushTimeRing(int ringSecond, int jobId) {
        List<Integer> ringItemData = ringData.get(ringSecond);
        if (ringItemData == null) {
            ringItemData = new ArrayList<Integer>();
            ringData.put(ringSecond, ringItemData);
        }
        ringItemData.add(jobId);
        logger.debug(">>>>>>>>>>> xxl-job, schedule push time-ring : " + ringSecond + " = " + Arrays.asList(ringItemData));
    }

    public void toStop() {
        this.scheduleThreadToStop = true;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.scheduleThread.getState() != Thread.State.TERMINATED) {
            this.scheduleThread.interrupt();
            try {
                this.scheduleThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        boolean hasRingData = false;
        if (!ringData.isEmpty()) {
            for (int second : ringData.keySet()) {
                List<Integer> tmpData = ringData.get(second);
                if (tmpData == null || tmpData.size() <= 0) continue;
                hasRingData = true;
                break;
            }
        }
        if (hasRingData) {
            try {
                TimeUnit.SECONDS.sleep(8L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.ringThreadToStop = true;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.ringThread.getState() != Thread.State.TERMINATED) {
            this.ringThread.interrupt();
            try {
                this.ringThread.join();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info(">>>>>>>>>>> xxl-job, JobScheduleHelper stop");
    }

    public static Date generateNextValidTime(XxlJobInfo jobInfo, Date fromTime) throws Exception {
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(jobInfo.getScheduleType(), null);
        if (ScheduleTypeEnum.CRON == scheduleTypeEnum) {
            Date nextValidTime = new CronExpression(jobInfo.getScheduleConf()).getNextValidTimeAfter(fromTime);
            return nextValidTime;
        }
        if (ScheduleTypeEnum.FIX_RATE == scheduleTypeEnum) {
            return new Date(fromTime.getTime() + (long)(Integer.valueOf(jobInfo.getScheduleConf()) * 1000));
        }
        return null;
    }
}

