/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.core.thread;

import com.xxl.job.admin.core.conf.XxlJobAdminConfig;
import com.xxl.job.admin.core.model.XxlJobLogReport;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogReportHelper {
    private static Logger logger = LoggerFactory.getLogger(JobLogReportHelper.class);
    private static JobLogReportHelper instance = new JobLogReportHelper();
    private Thread logrThread;
    private volatile boolean toStop = false;

    public static JobLogReportHelper getInstance() {
        return instance;
    }

    public void start() {
        this.logrThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long lastCleanLogTime = 0L;
                while (!JobLogReportHelper.this.toStop) {
                    block9: {
                        try {
                            for (int i = 0; i < 3; ++i) {
                                int ret;
                                Calendar itemDay = Calendar.getInstance();
                                itemDay.add(5, -i);
                                itemDay.set(11, 0);
                                itemDay.set(12, 0);
                                itemDay.set(13, 0);
                                itemDay.set(14, 0);
                                Date todayFrom = itemDay.getTime();
                                itemDay.set(11, 23);
                                itemDay.set(12, 59);
                                itemDay.set(13, 59);
                                itemDay.set(14, 999);
                                Date todayTo = itemDay.getTime();
                                XxlJobLogReport xxlJobLogReport = new XxlJobLogReport();
                                xxlJobLogReport.setTriggerDay(todayFrom);
                                xxlJobLogReport.setRunningCount(0);
                                xxlJobLogReport.setSucCount(0);
                                xxlJobLogReport.setFailCount(0);
                                Map<String, Object> triggerCountMap = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().findLogReport(todayFrom, todayTo);
                                if (triggerCountMap != null && triggerCountMap.size() > 0) {
                                    int triggerDayCount = triggerCountMap.containsKey("triggerDayCount") ? Integer.valueOf(String.valueOf(triggerCountMap.get("triggerDayCount"))) : 0;
                                    int triggerDayCountRunning = triggerCountMap.containsKey("triggerDayCountRunning") ? Integer.valueOf(String.valueOf(triggerCountMap.get("triggerDayCountRunning"))) : 0;
                                    int triggerDayCountSuc = triggerCountMap.containsKey("triggerDayCountSuc") ? Integer.valueOf(String.valueOf(triggerCountMap.get("triggerDayCountSuc"))) : 0;
                                    int triggerDayCountFail = triggerDayCount - triggerDayCountRunning - triggerDayCountSuc;
                                    xxlJobLogReport.setRunningCount(triggerDayCountRunning);
                                    xxlJobLogReport.setSucCount(triggerDayCountSuc);
                                    xxlJobLogReport.setFailCount(triggerDayCountFail);
                                }
                                if ((ret = XxlJobAdminConfig.getAdminConfig().getXxlJobLogReportDao().update(xxlJobLogReport)) >= 1) continue;
                                XxlJobAdminConfig.getAdminConfig().getXxlJobLogReportDao().save(xxlJobLogReport);
                            }
                        }
                        catch (Exception e) {
                            if (JobLogReportHelper.this.toStop) break block9;
                            logger.error(">>>>>>>>>>> xxl-job, job log report thread error:{}", (Throwable)e);
                        }
                    }
                    if (XxlJobAdminConfig.getAdminConfig().getLogretentiondays() > 0 && System.currentTimeMillis() - lastCleanLogTime > 86400000L) {
                        Calendar expiredDay = Calendar.getInstance();
                        expiredDay.add(5, -1 * XxlJobAdminConfig.getAdminConfig().getLogretentiondays());
                        expiredDay.set(11, 0);
                        expiredDay.set(12, 0);
                        expiredDay.set(13, 0);
                        expiredDay.set(14, 0);
                        Date clearBeforeTime = expiredDay.getTime();
                        List<Long> logIds = null;
                        do {
                            if ((logIds = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().findClearLogIds(0, 0, clearBeforeTime, 0, 1000)) == null || logIds.size() <= 0) continue;
                            XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().clearLog(logIds);
                        } while (logIds != null && logIds.size() > 0);
                        lastCleanLogTime = System.currentTimeMillis();
                    }
                    try {
                        TimeUnit.MINUTES.sleep(1L);
                    }
                    catch (Exception e) {
                        if (JobLogReportHelper.this.toStop) continue;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, job log report thread stop");
            }
        });
        this.logrThread.setDaemon(true);
        this.logrThread.setName("xxl-job, admin JobLogReportHelper");
        this.logrThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.logrThread.interrupt();
        try {
            this.logrThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

