/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.security.config;

import cn.dev33.satoken.context.SaTokenContext;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.filter.SaPathCheckFilterForJakartaServlet;
import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.violet.common.launch.config.launch.VioletProperties;
import org.violet.common.security.config.StpInterfaceImpl;
import org.violet.common.security.constants.AuthConst;
import org.violet.common.security.context.VioletSaTokenContextForSpringInJakartaServlet;
import org.violet.common.security.util.StpUserUtil;

@AutoConfiguration
@EnableConfigurationProperties(value={VioletProperties.class})
public class SaTokenConfiguration
implements WebMvcConfigurer {
    private final VioletProperties violetProperties;

    @Bean
    public SaTokenContext getSaTokenContextForSpringInJakartaServlet() {
        return new VioletSaTokenContextForSpringInJakartaServlet();
    }

    @Bean
    public SaPathCheckFilterForJakartaServlet saPathCheckFilterForJakartaServlet() {
        return new SaPathCheckFilterForJakartaServlet();
    }

    @Bean
    @ConditionalOnMissingBean
    public StpInterface stpInterface() {
        return new StpInterfaceImpl();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        ArrayList excludePath = CollUtil.newArrayList((Object[])AuthConst.EXCLUDE_PATH);
        if (CollUtil.isNotEmpty((Collection)this.violetProperties.getWhiteList())) {
            CollUtil.addAll((Collection)excludePath, (Iterable)this.violetProperties.getWhiteList());
        }
        registry.addInterceptor((HandlerInterceptor)new SaInterceptor(handle -> {
            if (!StpUtil.isLogin() && !StpUserUtil.isLogin()) {
                throw new SaTokenException("\u7528\u6237\u672a\u767b\u5f55");
            }
        })).addPathPatterns(new String[]{"/**"}).excludePathPatterns((List)excludePath);
    }

    @Generated
    public SaTokenConfiguration(VioletProperties violetProperties) {
        this.violetProperties = violetProperties;
    }
}

