package org.violet.common.security.config;

import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpUtil;
import org.violet.common.launch.constant.AppConstant;

import java.util.ArrayList;
import java.util.List;

/**
 * Sa-Token 的自定义权限验证扩展
 */
public class StpInterfaceImpl implements StpInterface {

    /**
     * 返回一个账号所拥有的权限码集合
     *
     * @param loginId
     * @param loginType
     * @return
     */
    @Override
    public List<String> getPermissionList(Object loginId, String loginType) {
        List<String> permissionList = new ArrayList<>();
        if (Long.valueOf(loginId.toString()).equals(AppConstant.DEF_ROOT_USER_ID)) {
            permissionList.add("*");
        } else {
            Object o = StpUtil.getTokenSession().get("USER_AUTH");
            if (o != null) {
                permissionList.addAll((List<String>) o);
            }
        }
        return permissionList;
    }

    /**
     * 返回一个账号所拥有的权限码集合
     *
     * @param loginId
     * @param loginType
     * @return
     */
    @Override
    public List<String> getRoleList(Object loginId, String loginType) {
        List<String> roleList = new ArrayList<>();
        if (Long.valueOf(loginId.toString()).equals(AppConstant.DEF_ROOT_USER_ID)) {
            roleList.add("ADMIN");
        }
        return roleList;
    }
}
