package org.violet.common.mybatis.base;

import com.alibaba.fastjson2.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.Date;

/**
 * 数据库实体基类
 */
@Data
public class BaseEntity {
    @JsonIgnore
    @JSONField(
            serialize = false
    )
    @TableLogic(
            value = "0",
            delval = "1"
    )
    private Integer deleted = 0;
    @JsonIgnore
    @TableField(
            fill = FieldFill.INSERT
    )
    private Long createBy;
    @JsonIgnore
    @TableField(
            fill = FieldFill.INSERT_UPDATE
    )
    private Long modifyBy;
    @JsonIgnore
    @TableField(
            fill = FieldFill.INSERT
    )
    @JSONField(
            serialize = false
    )
    private Date createTime;
    @JsonIgnore
    @TableField(
            fill = FieldFill.INSERT_UPDATE
    )
    @JSONField(
            serialize = false
    )
    private Date modifyTime;

    public BaseEntity() {
    }

}