/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.mybatis.pojo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.yulichang.wrapper.JoinAbstractWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class PageRequest<T>
implements IPage<T> {
    private List<OrderField> sorts = new ArrayList<OrderField>();
    public static final long DEFAULT_SIZE = 20L;
    protected long current = 1L;
    private long total = 0L;
    private long size = 20L;
    private List<T> rows = Collections.emptyList();
    private String orders;

    public List<OrderItem> orders() {
        return new ArrayList<OrderItem>();
    }

    @JsonIgnore
    public List<T> getRecords() {
        return this.rows;
    }

    public IPage<T> setRecords(List<T> records) {
        this.rows = records;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public IPage<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public IPage<T> setSize(long size) {
        this.size = size;
        return this;
    }

    public long getCurrent() {
        return this.current;
    }

    public IPage<T> setCurrent(long current) {
        this.current = current;
        return this;
    }

    public void setOrders(String orders) {
        this.orders = orders;
    }

    public String getOrders() {
        return this.orders;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public static PageRequest of(long currentPage, long pageSize) {
        PageRequest pageRequest = new PageRequest();
        if (currentPage > 0L) {
            pageRequest.setCurrent(currentPage);
        }
        if (pageSize > 0L) {
            pageRequest.setSize(pageSize);
        }
        return pageRequest;
    }

    public static <T> PageRequest<T> defaultPage() {
        return PageRequest.of(1L, 20L);
    }

    public boolean hasSorts() {
        return !CollUtil.isEmpty(this.sorts);
    }

    public void appendSortsToWrapper(AbstractWrapper queryWrapper, Function<OrderField, String> fieldNameFunc) {
        if (this.hasSorts()) {
            this.getSorts().forEach(item -> {
                if (fieldNameFunc == null) {
                    queryWrapper.orderBy(true, item.isAsc(), (Object)item.getField(true));
                } else {
                    queryWrapper.orderBy(true, item.isAsc(), fieldNameFunc.apply((OrderField)item));
                }
            });
        }
    }

    public void appendSortsToWrapper(JoinAbstractWrapper queryWrapper, Function<OrderField, String> fieldNameFunc) {
        if (this.hasSorts()) {
            this.getSorts().forEach(item -> {
                if (fieldNameFunc == null) {
                    queryWrapper.orderBy(true, item.isAsc(), item.getField(true));
                } else {
                    queryWrapper.orderBy(true, item.isAsc(), (String)fieldNameFunc.apply((OrderField)item));
                }
            });
        }
    }

    public void appendSortsToWrapper(AbstractWrapper queryWrapper) {
        this.appendSortsToWrapper(queryWrapper, (Function<OrderField, String>)null);
    }

    public void appendSortsToWrapper(JoinAbstractWrapper queryWrapper) {
        this.appendSortsToWrapper(queryWrapper, (Function<OrderField, String>)null);
    }

    public void buildSorts(String sortFields, String orders) {
        if (StrUtil.isNotBlank((CharSequence)sortFields) && StrUtil.isNotBlank((CharSequence)orders)) {
            List fieldList = StrUtil.split((CharSequence)sortFields, (char)',');
            final List orderList = StrUtil.split((CharSequence)orders, (char)',');
            CollUtil.forEach((Iterable)fieldList, (CollUtil.Consumer)new CollUtil.Consumer<String>(){

                public void accept(String field, int index) {
                    String order = (String)CollUtil.get((Collection)orderList, (int)index);
                    PageRequest.this.addSortItem(field, order);
                }
            });
        }
    }

    public void addSortItem(String field, String order) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<OrderField>();
        }
        if (StrUtil.isNotBlank((CharSequence)field) && StrUtil.isNotBlank((CharSequence)order)) {
            OrderField orderItem = new OrderField();
            orderItem.setField(field);
            orderItem.setAsc(StrUtil.equalsIgnoreCase((CharSequence)order, (CharSequence)"asc"));
            this.sorts.add(orderItem);
        }
    }

    public List<OrderField> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<OrderField> sorts) {
        this.sorts = sorts;
    }

    public static class OrderField {
        private String field;
        private boolean asc = true;

        public String getField(boolean underline) {
            return underline ? StrUtil.toUnderlineCase((CharSequence)this.field) : this.field;
        }

        public String getField() {
            return this.field;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setAsc(boolean asc) {
            this.asc = asc;
        }
    }
}

