/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.loadbalance.processor;

import com.alibaba.nacos.common.utils.StringUtils;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.violet.common.loadbalance.config.VioletBalancerProperties;
import reactor.core.publisher.Mono;

public class GrayscaleLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrayscaleLoadBalancer.class);
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final VioletBalancerProperties violetBalancerProperties;

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(serviceInstances -> this.getInstanceResponse((List<ServiceInstance>)serviceInstances, request));
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances, Request request) {
        DefaultRequestContext context;
        RequestData requestData;
        HttpHeaders headers;
        String versionName;
        if (CollectionUtils.isEmpty(instances)) {
            return new EmptyResponse();
        }
        List<String> priorIpPattern = this.violetBalancerProperties.getPriorIpPattern();
        if (!priorIpPattern.isEmpty()) {
            String[] priorIpPatterns = priorIpPattern.toArray(new String[0]);
            List priorIpInstances = instances.stream().filter(i -> PatternMatchUtils.simpleMatch((String[])priorIpPatterns, (String)i.getHost())).collect(Collectors.toList());
            if (!priorIpInstances.isEmpty()) {
                instances = priorIpInstances;
            }
        }
        if (StringUtils.isBlank((CharSequence)(versionName = (headers = (requestData = (RequestData)(context = (DefaultRequestContext)request.getContext()).getClientRequest()).getHeaders()).getFirst("version")))) {
            List<ServiceInstance> noneGrayscaleInstances = instances.stream().filter(i -> !i.getMetadata().containsKey("version")).collect(Collectors.toList());
            return this.randomInstance(noneGrayscaleInstances);
        }
        List<ServiceInstance> grayscaleInstances = instances.stream().filter(i -> {
            String versionNameInMetadata = (String)i.getMetadata().get("version");
            return StringUtils.equalsIgnoreCase((String)versionNameInMetadata, (String)versionName);
        }).collect(Collectors.toList());
        return this.randomInstance(grayscaleInstances);
    }

    private Response<ServiceInstance> randomInstance(List<ServiceInstance> instances) {
        if (instances.isEmpty()) {
            return new EmptyResponse();
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(instances.size());
        ServiceInstance instance = instances.get(randomIndex % instances.size());
        return new DefaultResponse(instance);
    }

    @Generated
    public GrayscaleLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider, VioletBalancerProperties violetBalancerProperties) {
        this.serviceInstanceListSupplierProvider = serviceInstanceListSupplierProvider;
        this.violetBalancerProperties = violetBalancerProperties;
    }
}

