/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.violet.common.launch.service.LauncherService;

public class VioletApplication {
    public static ConfigurableApplicationContext run(String appName, Class<?> source, String ... args) {
        SpringApplicationBuilder builder = VioletApplication.createSpringApplicationBuilder(appName, source, args);
        return builder.run(args);
    }

    public static SpringApplicationBuilder createSpringApplicationBuilder(String appName, Class<?> source, String ... args) {
        return VioletApplication.createSpringApplicationBuilder(appName, source, null, args);
    }

    public static SpringApplicationBuilder createSpringApplicationBuilder(String appName, Class<?> source, SpringApplicationBuilder builder, String ... args) {
        String profile;
        Assert.hasText((String)appName, (String)"[appName]\u670d\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        propertySources.addLast((PropertySource)new MapPropertySource("systemProperties", environment.getSystemProperties()));
        propertySources.addLast((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", environment.getSystemEnvironment()));
        Object[] activeProfiles = environment.getActiveProfiles();
        List<String> profiles = Arrays.asList(activeProfiles);
        ArrayList<String> presetProfiles = new ArrayList<String>(Arrays.asList("dev", "test", "prod"));
        presetProfiles.retainAll(profiles);
        ArrayList<String> activeProfileList = new ArrayList<String>(profiles);
        Function<Object[], String> joinFun = StringUtils::arrayToCommaDelimitedString;
        if (builder == null) {
            builder = new SpringApplicationBuilder(new Class[]{source});
        }
        if (activeProfileList.isEmpty()) {
            profile = "dev";
            activeProfileList.add(profile);
            builder.profiles(new String[]{profile});
        } else if (activeProfileList.size() == 1) {
            profile = (String)activeProfileList.get(0);
        } else {
            throw new RuntimeException("\u540c\u65f6\u5b58\u5728\u73af\u5883\u53d8\u91cf:[" + StringUtils.arrayToCommaDelimitedString((Object[])activeProfiles) + "]");
        }
        String startJarPath = VioletApplication.class.getResource("/").getPath().split("!")[0];
        String activePros = joinFun.apply(activeProfileList.toArray());
        System.out.println(String.format("----\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[%s]\uff0cjar\u5730\u5740:[%s]----", activePros, startJarPath));
        Properties props = System.getProperties();
        props.setProperty("spring.application.name", appName);
        props.setProperty("spring.profiles.active", profile);
        props.setProperty("info.version", "1.0.0");
        props.setProperty("info.desc", appName);
        props.setProperty("violent.env", profile);
        props.setProperty("violent.name", appName);
        props.setProperty("violent.is-local", String.valueOf(VioletApplication.isLocalDev()));
        props.setProperty("violent.dev-mode", profile.equals("prod") ? "false" : "true");
        props.setProperty("violent.service.version", "1.0.0");
        props.setProperty("spring.main.allow-bean-definition-overriding", "true");
        ArrayList launcherList = new ArrayList();
        ServiceLoader.load(LauncherService.class).forEach(launcherList::add);
        SpringApplicationBuilder finalBuilder = builder;
        launcherList.stream().sorted(Comparator.comparing(LauncherService::getOrder)).collect(Collectors.toList()).forEach(launcherService -> launcherService.launcher(finalBuilder, appName, profile));
        return finalBuilder;
    }

    public static boolean isLocalDev() {
        String osName = System.getProperty("os.name");
        return StringUtils.hasText((String)osName) && !"LINUX".equals(osName.toUpperCase());
    }
}

