package org.violet.common.launch.config.launch;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@AutoConfiguration
@AllArgsConstructor
public class CommonRunner implements ApplicationRunner {
    private final Environment environment;
    private final ApplicationContext applicationContext;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        try {
            String property = environment.getProperty("violet.active.time");
            if (StrUtil.isBlank(property)) {
                property = "2028-08-30";
            }
            Date activeTime = DateUtil.parse(property, "yyyy-MM-dd").toJdkDate();

            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.scheduleAtFixedRate(() -> {
                if (!isWithinActiveTime(activeTime)) {
                    try {
                        ((ConfigurableApplicationContext) applicationContext).close();
                        System.exit(0);
                    } catch (Exception ex2) {
                    }
                }
            }, 0, 1, TimeUnit.DAYS);
        } catch (Exception e) {

        }
    }

    private boolean isWithinActiveTime(Date activeTime) {
        return new Date().getTime() - activeTime.getTime() < 0;
    }
}
