package org.flywaydb.core.internal.database.kingbase;

import org.flywaydb.core.internal.database.base.Type;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

import java.sql.SQLException;

/**
 * @author xu.wenchang
 * @version 1.0 2023/10/17
 */
public class KingbaseType extends Type<KingbaseDatabase, KingbaseSchema> {
    public KingbaseType(JdbcTemplate jdbcTemplate, KingbaseDatabase database, KingbaseSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }
    
    @Override
    protected void doDrop() throws SQLException {
        jdbcTemplate.execute("DROP TYPE " + database.quote(schema.getName(), name));
    }
}