package org.violet.common.datascope.handler;

import org.violet.common.core.embed.dict.AuthType;
import org.violet.common.core.embed.dict.CommonDataAuth;
import org.violet.common.core.entity.LoginUser;
import org.violet.common.core.util.Func;
import org.violet.common.core.util.StringUtil;
import org.violet.common.datascope.annotations.DataScope;
import org.violet.common.datascope.constants.DataScopeColumnConstants;

public class DataScopeHandler {
    public String sqlCondition(String mapperId, DataScope dataScope, LoginUser longinUser, String originalSql) {
        //判断该用户是否拥有该数据权限,即被限制了数据权限
        if (longinUser.getAuthMap() != null && longinUser.getAuthMap().containsKey(AuthType.DATA.name())) {
            //判断该用户是否存在该数据权限，没有不进行控制
            if (!longinUser.getAuthMap().get(AuthType.DATA.name())
                    .contains(dataScope.authCode() + ":" + dataScope.dataAuth().name())) {

                return null;
            }
        } else {
            //没有数据权限，不做限制
            return null;
        }

        //存在数据权限
        String whereSql = "where scope.{} = {}";
        if (dataScope.dataAuth() == CommonDataAuth.CURRENT_ORG_DATA) {
            //当前机构数据权限
            whereSql = StringUtil.format(whereSql,
                    StringUtil.isBlank(dataScope.scopeColumn()) ? DataScopeColumnConstants.DATA_SCOPE_ORG : dataScope.scopeColumn(),
                    longinUser.getOrgId());
        } else if (dataScope.dataAuth() == CommonDataAuth.CURRENT_DEPT_DATA) {
            //当前部门数据权限
            whereSql = StringUtil.format(whereSql,
                    StringUtil.isBlank(dataScope.scopeColumn()) ? DataScopeColumnConstants.DATA_SCOPE_DEPT : dataScope.scopeColumn(), longinUser.getDeptId());
        } else if (dataScope.dataAuth() == CommonDataAuth.CURRENT_EMP_DATA) {
            //当前用户数据权限
            whereSql = StringUtil.format(whereSql,
                    StringUtil.isBlank(dataScope.scopeColumn()) ?
                            DataScopeColumnConstants.DATA_SCOPE_USER : dataScope.scopeColumn(),
                    longinUser.getUserId());
        } else {
            return null;
        }

        return StringUtil.format("select {} from ({}) scope ", "*", originalSql) + whereSql;

    }
}
