package org.violet.common.datascope.annotations;


import org.violet.common.core.embed.dict.CommonDataAuth;

import java.lang.annotation.*;

/**
 * 此注解必须加载mapper接口的方法，只能支持数据查询操作，可以指定数据权限和角色权限
 * 此外必须存在相关的数据权限控制列，否则查询时会报错
 *
 * <p>
 * 在mybatisPlus的wrapper中使用
 * 对于通过 baseMapper查询的数据，需要添加一个中间层mapper去集成baseMapper，在该mapper中添加此注解，并在该注解中指定数据权限控制和角色权限
 * <p>
 */

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface DataScope {

    //数据权限控制
    String authCode();

    //角色权限控制
    CommonDataAuth dataAuth();

    //自定义权限控制列，如果没有配置根据角色权限控制类型使用默认的权限控制列
    String scopeColumn() default "";


}
