package org.violet.commom.crypto.annotation.encrypt;


import org.springframework.core.annotation.AliasFor;
import org.violet.commom.crypto.enums.CryptoType;

import java.lang.annotation.*;

/**
 * des 加密
 *
 * @see ApiEncrypt
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@ApiEncrypt(CryptoType.DES)
public @interface ApiEncryptDes {

	/**
	 * Alias for {@link ApiEncrypt#secretKey()}.
	 *
	 * @return {String}
	 */
	@AliasFor(annotation = ApiEncrypt.class)
	String secretKey() default "";

}
