/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.cloud.feign;

import com.fasterxml.jackson.databind.JsonNode;
import feign.FeignException;
import java.lang.reflect.Method;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.lang.Nullable;
import org.violet.common.core.util.JsonUtil;
import org.violet.common.core.util.ObjectUtil;
import org.violet.common.launch.entity.JsonResult;

public class VioletFeignFallback<T>
implements MethodInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VioletFeignFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;
    private static final String CODE = "code";

    @Nullable
    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        log.error("VioletFeignFallback:[{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        Class<?> returnType = method.getReturnType();
        if (JsonResult.class != returnType) {
            return null;
        }
        if (!(this.cause instanceof FeignException)) {
            return JsonResult.ERROR((String)errorMessage);
        }
        FeignException exception = (FeignException)this.cause;
        byte[] content = exception.content();
        if (ObjectUtil.isEmpty((Object)content)) {
            return JsonResult.ERROR((String)errorMessage);
        }
        try {
            JsonNode resultNode = null;
            resultNode = JsonUtil.readTree((byte[])content);
            if (resultNode.has(CODE)) {
                return JsonUtil.getInstance().convertValue((Object)resultNode, JsonResult.class);
            }
            return JsonResult.ERROR((String)resultNode.toString());
        }
        catch (Exception exception2) {
            return JsonResult.ERROR((String)errorMessage);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VioletFeignFallback that = (VioletFeignFallback)o;
        return this.targetType.equals(that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.targetType);
    }

    @Generated
    public VioletFeignFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }
}

