package org.violet.common.cloud.feign.header;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.lang.Nullable;

import java.util.Arrays;
import java.util.List;

/**
 * Hystrix Headers 配置
 */
@Getter
@Setter
@RefreshScope
@ConfigurationProperties("violet.feign.headers")
public class VioletFeignHeadersProperties {
    
    /**
     * RestTemplate 和 Fegin 透传到下层的 Headers 名称表达式
     */
    @Nullable
    private String pattern = "Violet*";

    /**
     * RestTemplate 和 Fegin 透传到下层的 Headers 名称列表
     */
    private List<String> allowed = Arrays.asList("X-Real-IP", "x-forwarded-for", "token");

}
