package org.violet.common.cloud.config;

import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import feign.Feign;
import feign.RequestInterceptor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.violet.common.cloud.feign.VioletSentinelFeign;
import org.violet.common.cloud.feign.header.VioletFeignHeadersProperties;
import org.violet.common.cloud.feign.header.VioletFeignRequestHeaderInterceptor;
import org.violet.common.cloud.sentinel.VioletBlockExceptionHandler;

/***
 * 微服务增强配置
 * @author wjx
 * @date 2024/11/28 16:38
 */
@AutoConfiguration
@Import(VioletSentinelFilterConfiguration.class)
@AutoConfigureBefore(SentinelFeignAutoConfiguration.class)
public class VioletCloudAutoConfiguration {

    //对feign进行增强，设置默认的fallback，即服务降级返回
    @Bean
    @Scope("prototype")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name = "feign.sentinel.enabled")
    public Feign.Builder feignSentinelBuilder(RequestInterceptor requestInterceptor) {
        return VioletSentinelFeign.builder().requestInterceptor(requestInterceptor);
    }

    //自定义限流返回
    @Bean
    @ConditionalOnMissingBean
    public BlockExceptionHandler blockExceptionHandler() {
        return new VioletBlockExceptionHandler();
    }

    //向feign的restTemplate添加请求头
    @Bean
    @ConditionalOnMissingBean
    public RequestInterceptor requestInterceptor(VioletFeignHeadersProperties violetFeignHeadersProperties) {
        return new VioletFeignRequestHeaderInterceptor(violetFeignHeadersProperties);
    }

}
