package org.violet.common.bootstrap.handler.adapter;

import cn.dev33.satoken.exception.*;
import com.google.auto.service.AutoService;
import org.violet.common.launch.entity.JsonResult;
import lombok.extern.slf4j.Slf4j;
import org.violet.common.bootstrap.handler.ExceptionAdapter;
import org.violet.common.core.util.CommonServletUtil;

@Slf4j
@AutoService(ExceptionAdapter.class)
public class AuthExceptionAdapter implements ExceptionAdapter {
    public AuthExceptionAdapter() {
    }

    public String[] supportExceptions() {
        return new String[]{SaTokenException.class.getName(), NotLoginException.class.getName(), NotPermissionException.class.getName(), NotRoleException.class.getName()};
    }

    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR("权限认证异常");
        if (e instanceof NotLoginException) {
            NotLoginException notLoginException = (NotLoginException) e;
            result = JsonResult.ERROR(notLoginException.getMessage()).code(401);
        } else if (e instanceof NotRoleException) {
            NotRoleException notRoleException = (NotRoleException) e;
            String var10000 = notRoleException.getRole();
            result = JsonResult.ERROR("无此角色：" + var10000 + "，接口地址：" + CommonServletUtil.getRequest().getServletPath()).code(403);
        } else if (e instanceof NotPermissionException) {
            NotPermissionException notPermissionException = (NotPermissionException) e;
            result = JsonResult.ERROR("无此权限：" + notPermissionException.getPermission()).code(403);
        } else if (e instanceof DisableServiceException) {
            DisableServiceException disableServiceException = (DisableServiceException) e;
            result = JsonResult.ERROR("账号被封禁：" + disableServiceException.getDisableTime() + "秒后解封").code(403);
        } else if (e instanceof SaTokenException) {
            SaTokenException saTokenException = (SaTokenException) e;
            result = JsonResult.ERROR(saTokenException.getMessage()).code(401);
        } else {
            log.error(">>> 服务器未知异常，请求地址：{}，具体信息：", CommonServletUtil.getRequest().getRequestURL(), e);
            result = JsonResult.ERROR("服务器未知异常");
        }

        return result;
    }
}