/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.bootstrap.handler.adapter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.auto.service.AutoService;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Set;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.violet.common.bootstrap.handler.ExceptionAdapter;
import org.violet.common.launch.entity.JsonResult;

@AutoService(value={ExceptionAdapter.class})
public class HttpParamsValidExceptionAdapter
implements ExceptionAdapter {
    @Override
    public String[] supportExceptions() {
        return new String[]{MethodArgumentNotValidException.class.getName(), BindException.class.getName(), ConstraintViolationException.class.getName(), MissingServletRequestParameterException.class.getName()};
    }

    @Override
    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR((String)e.getMessage());
        if (e instanceof BindException) {
            BindException exception = (BindException)e;
            result.msg(this.getArgNotValidMessage(exception.getBindingResult()));
        } else if (e instanceof ConstraintViolationException) {
            ConstraintViolationException exception = (ConstraintViolationException)e;
            result.msg(HttpParamsValidExceptionAdapter.getArgNotValidMessage(exception.getConstraintViolations()));
        } else if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException exception = (MissingServletRequestParameterException)e;
            result.msg(exception.getMessage());
        }
        return result;
    }

    public String getArgNotValidMessage(BindingResult bindingResult) {
        if (ObjectUtil.isNull((Object)bindingResult)) {
            return "";
        }
        StringBuilder stringBuilder = StrUtil.builder();
        List allErrorInfos = bindingResult.getAllErrors();
        for (ObjectError error : allErrorInfos) {
            stringBuilder.append(",").append(error.getDefaultMessage());
        }
        return StrUtil.removePrefix((CharSequence)stringBuilder.toString(), (CharSequence)",");
    }

    public static String getArgNotValidMessage(Set<ConstraintViolation<?>> constraintViolationSet) {
        if (ObjectUtil.isEmpty(constraintViolationSet)) {
            return "";
        }
        StringBuilder stringBuilder = StrUtil.builder();
        for (ConstraintViolation<?> constraintViolation : constraintViolationSet) {
            stringBuilder.append(",").append(constraintViolation.getMessage());
        }
        return StrUtil.removePrefix((CharSequence)stringBuilder.toString(), (CharSequence)",");
    }
}

