/*
 * Decompiled with CFR 0.152.
 */
package org.violet.common.bootstrap.handler.adapter;

import cn.dev33.satoken.exception.DisableServiceException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import com.google.auto.service.AutoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.violet.common.bootstrap.handler.ExceptionAdapter;
import org.violet.common.core.util.CommonServletUtil;
import org.violet.common.launch.entity.JsonResult;

@AutoService(value={ExceptionAdapter.class})
public class AuthExceptionAdapter
implements ExceptionAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthExceptionAdapter.class);

    @Override
    public String[] supportExceptions() {
        return new String[]{SaTokenException.class.getName(), NotLoginException.class.getName(), NotPermissionException.class.getName(), NotRoleException.class.getName()};
    }

    @Override
    public JsonResult adapter(Throwable e) {
        JsonResult result = JsonResult.ERROR((String)"\u6743\u9650\u8ba4\u8bc1\u5f02\u5e38");
        if (e instanceof NotLoginException) {
            NotLoginException notLoginException = (NotLoginException)e;
            result = JsonResult.ERROR((String)notLoginException.getMessage()).code(401);
        } else if (e instanceof NotRoleException) {
            NotRoleException notRoleException = (NotRoleException)e;
            String var10000 = notRoleException.getRole();
            result = JsonResult.ERROR((String)("\u65e0\u6b64\u89d2\u8272\uff1a" + var10000 + "\uff0c\u63a5\u53e3\u5730\u5740\uff1a" + CommonServletUtil.getRequest().getServletPath())).code(403);
        } else if (e instanceof NotPermissionException) {
            NotPermissionException notPermissionException = (NotPermissionException)e;
            result = JsonResult.ERROR((String)("\u65e0\u6b64\u6743\u9650\uff1a" + notPermissionException.getPermission())).code(403);
        } else if (e instanceof DisableServiceException) {
            DisableServiceException disableServiceException = (DisableServiceException)e;
            result = JsonResult.ERROR((String)("\u8d26\u53f7\u88ab\u5c01\u7981\uff1a" + disableServiceException.getDisableTime() + "\u79d2\u540e\u89e3\u5c01")).code(403);
        } else if (e instanceof SaTokenException) {
            SaTokenException saTokenException = (SaTokenException)e;
            result = JsonResult.ERROR((String)saTokenException.getMessage()).code(401);
        } else {
            log.error(">>> \u670d\u52a1\u5668\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5177\u4f53\u4fe1\u606f\uff1a", (Object)CommonServletUtil.getRequest().getRequestURL(), (Object)e);
            result = JsonResult.ERROR((String)"\u670d\u52a1\u5668\u672a\u77e5\u5f02\u5e38");
        }
        return result;
    }
}

