/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filepreview.utils;

import com.xiaoleilu.hutool.io.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static Logger logger = LoggerFactory.getLogger(ResourceUtil.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String read(InputStream in) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return ResourceUtil.read(reader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block4: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    String path = ResourceUtil.class.getResource("/").toString();
                    URL url = new URL(String.valueOf(path) + resource);
                    in = url.openStream();
                }
                if (in != null) break block4;
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
            IoUtil.close((Closeable)in);
            return null;
        }
        String string = text = ResourceUtil.read(in);
        IoUtil.close((Closeable)in);
        return string;
    }

    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block4: {
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    String path = ResourceUtil.class.getResource("/").toString();
                    URL url = new URL(String.valueOf(path) + resource);
                    in = url.openStream();
                }
                if (in != null) break block4;
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
            IoUtil.close((Closeable)in);
            return null;
        }
        byte[] byArray = ResourceUtil.readByteArray(in);
        IoUtil.close((Closeable)in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ResourceUtil.copy(input, output);
        return output.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int EOF = -1;
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String getFileEncodeUTFGBK(String path) {
        String enc;
        block7: {
            enc = Charset.forName("GBK").name();
            File file = new File(path);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                byte[] b = new byte[3];
                ((InputStream)in).read(b);
                ((InputStream)in).close();
                if (b[0] == -17 && b[1] == -69 && b[2] == -65) {
                    enc = Charset.forName("UTF-8").name();
                }
            }
            catch (FileNotFoundException e) {
                logger.error("\u83b7\u53d6\u6587\u4ef6\u7f16\u7801\u5931\u8d25", (Throwable)e);
                IoUtil.close((Closeable)in);
                break block7;
            }
            catch (IOException e) {
                try {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u7f16\u7801\u5931\u8d25", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IoUtil.close(in);
                    throw throwable;
                }
                IoUtil.close((Closeable)in);
                break block7;
            }
            IoUtil.close((Closeable)in);
        }
        return enc;
    }
}

