/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filepreview.utils;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import com.kdgcsoft.power.filepreview.utils.ResourceUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IoUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressFileReader {
    private static Logger logger = LoggerFactory.getLogger(CompressFileReader.class);
    private static final Collator TEXT_COMPARATOR = Collator.getInstance();
    private static final int MAX_DISPLAY_ITEMS = 100;
    private static List<Map<String, String>> READ_ERROR_RESULT = new ArrayList<Map<String, String>>();
    private static Map<String, String> MAX_ITEMS_MESSAGE = CompressFileReader.createFileInfo("---\u9884\u89c8\u754c\u9762\u6700\u591a\u53ea\u663e\u793a100\u6761\u8bb0\u5f55---", "");

    static {
        READ_ERROR_RESULT.add(CompressFileReader.createFileInfo("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff01", ""));
    }

    public static List<Map<String, String>> readZipFile(InputStream is, String viewtype) {
        ArrayList<Map<String, String>> filelist;
        block23: {
            filelist = new ArrayList<Map<String, String>>();
            int count = 0;
            if ("zip".equalsIgnoreCase(viewtype) || "jar".equalsIgnoreCase(viewtype)) {
                File tmpfile = CompressFileReader.StreamToTmpFile(is);
                if (tmpfile == null) {
                    return READ_ERROR_RESULT;
                }
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(tmpfile, ResourceUtil.getFileEncodeUTFGBK(tmpfile.getAbsolutePath()));
                        Enumeration entries = zipFile.getEntries();
                        while (entries.hasMoreElements()) {
                            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                            filelist.add(CompressFileReader.createFileInfo(entry.getName(), entry.isDirectory(), entry.getCompressedSize()));
                            if (++count < 100) continue;
                            filelist.add(MAX_ITEMS_MESSAGE);
                            break;
                        }
                    }
                    catch (IOException e1) {
                        logger.error("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e1);
                        List<Map<String, String>> list = READ_ERROR_RESULT;
                        IoUtil.close((Closeable)zipFile);
                        CompressFileReader.deleteTmpFile(tmpfile);
                        return list;
                    }
                }
                catch (Throwable throwable) {
                    IoUtil.close(zipFile);
                    CompressFileReader.deleteTmpFile(tmpfile);
                    throw throwable;
                }
                IoUtil.close((Closeable)zipFile);
                CompressFileReader.deleteTmpFile(tmpfile);
            } else {
                if ("tar".equalsIgnoreCase(viewtype)) {
                    TarArchiveInputStream tarIn = new TarArchiveInputStream(is, 2048);
                    TarArchiveEntry entry = null;
                    try {
                        try {
                            while ((entry = tarIn.getNextTarEntry()) != null) {
                                filelist.add(CompressFileReader.createFileInfo(entry.getName(), entry.isDirectory(), entry.getSize()));
                                if (++count < 100) continue;
                                filelist.add(MAX_ITEMS_MESSAGE);
                                break block23;
                            }
                            break block23;
                        }
                        catch (IOException e) {
                            logger.error("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                            List<Map<String, String>> list = READ_ERROR_RESULT;
                            IoUtil.close((Closeable)tarIn);
                            return list;
                        }
                    }
                    finally {
                        IoUtil.close((Closeable)tarIn);
                    }
                }
                if ("7z".equalsIgnoreCase(viewtype)) {
                    File tmpfile = CompressFileReader.StreamToTmpFile(is);
                    if (tmpfile == null) {
                        return READ_ERROR_RESULT;
                    }
                    SevenZFile sevenZFile = null;
                    try {
                        try {
                            sevenZFile = new SevenZFile(tmpfile);
                            SevenZArchiveEntry entry = null;
                            while ((entry = sevenZFile.getNextEntry()) != null) {
                                filelist.add(CompressFileReader.createFileInfo(entry.getName(), entry.isDirectory(), entry.getSize()));
                                if (++count < 100) continue;
                                filelist.add(MAX_ITEMS_MESSAGE);
                                break;
                            }
                        }
                        catch (IOException e) {
                            logger.error("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                            List<Map<String, String>> list = READ_ERROR_RESULT;
                            IoUtil.close((Closeable)sevenZFile);
                            CompressFileReader.deleteTmpFile(tmpfile);
                            return list;
                        }
                    }
                    catch (Throwable throwable) {
                        IoUtil.close(sevenZFile);
                        CompressFileReader.deleteTmpFile(tmpfile);
                        throw throwable;
                    }
                    IoUtil.close((Closeable)sevenZFile);
                    CompressFileReader.deleteTmpFile(tmpfile);
                }
            }
        }
        return filelist;
    }

    public static List<Map<String, String>> readRarFile(InputStream is) {
        List headers;
        Archive archive;
        File tmpfile;
        ArrayList<Map<String, String>> filelist;
        block7: {
            filelist = new ArrayList<Map<String, String>>();
            tmpfile = CompressFileReader.StreamToTmpFile(is);
            if (tmpfile == null) {
                return READ_ERROR_RESULT;
            }
            archive = null;
            archive = new Archive(tmpfile);
            headers = archive.getFileHeaders();
            if (headers.size() != 0) break block7;
            List<Map<String, String>> list = READ_ERROR_RESULT;
            IoUtil.close((Closeable)archive);
            CompressFileReader.deleteTmpFile(tmpfile);
            return list;
        }
        try {
            try {
                CompressFileReader.sortHeaders(headers);
                int count = 0;
                for (FileHeader header : headers) {
                    String fullName = header.isUnicode() ? header.getFileNameW() : header.getFileNameString();
                    filelist.add(CompressFileReader.createFileInfo(fullName, header.isDirectory(), header.getDataSize()));
                    if (++count < 100) continue;
                    filelist.add(MAX_ITEMS_MESSAGE);
                    break;
                }
            }
            catch (Exception e) {
                logger.error("\u8bfb\u53d6Rar\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                List<Map<String, String>> list = READ_ERROR_RESULT;
                IoUtil.close((Closeable)archive);
                CompressFileReader.deleteTmpFile(tmpfile);
                return list;
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(archive);
            CompressFileReader.deleteTmpFile(tmpfile);
            throw throwable;
        }
        IoUtil.close((Closeable)archive);
        CompressFileReader.deleteTmpFile(tmpfile);
        return filelist;
    }

    public static void sortHeaders(List<FileHeader> headers) {
        Collections.sort(headers, new Comparator<FileHeader>(){

            @Override
            public int compare(FileHeader o1, FileHeader o2) {
                if (o1.isDirectory() == o2.isDirectory()) {
                    return TEXT_COMPARATOR.compare(o1.getFileNameW(), o2.getFileNameW());
                }
                if (o1.isDirectory()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    private static Map<String, String> createFileInfo(String fileName, String fileSize) {
        HashMap<String, String> fileInfo = new HashMap<String, String>();
        fileInfo.put("filename", fileName);
        fileInfo.put("filesize", fileSize);
        return fileInfo;
    }

    private static Map<String, String> createFileInfo(String fileName, boolean isDirectory, long fileSize) {
        if (isDirectory) {
            return CompressFileReader.createFileInfo(fileName, "");
        }
        return CompressFileReader.createFileInfo(fileName, CompressFileReader.getDataSize(fileSize));
    }

    public static String getDataSize(long size) {
        DecimalFormat formater = new DecimalFormat("####.00");
        if (size <= 0L) {
            return "0";
        }
        if (size < 1024L) {
            return String.valueOf(size) + "bytes";
        }
        if (size < 0x100000L) {
            float kbsize = (float)size / 1024.0f;
            return String.valueOf(formater.format(kbsize)) + "KB";
        }
        if (size < 0x40000000L) {
            float mbsize = (float)size / 1024.0f / 1024.0f;
            return String.valueOf(formater.format(mbsize)) + "MB";
        }
        if (size < 0L) {
            float gbsize = (float)size / 1024.0f / 1024.0f / 1024.0f;
            return String.valueOf(formater.format(gbsize)) + "GB";
        }
        return "size: error";
    }

    public static File StreamToTmpFile(InputStream is) {
        File tmpfile;
        block5: {
            tmpfile = null;
            FileOutputStream os = null;
            try {
                try {
                    tmpfile = FileUtil.createTempFile((String)"filepreview", null, null, (boolean)true);
                    os = new FileOutputStream(tmpfile);
                    IoUtil.copy((InputStream)is, (OutputStream)os, (int)8192);
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u6d41\u5199\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                    IoUtil.close(os);
                    IoUtil.close((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(os);
                IoUtil.close((Closeable)is);
                throw throwable;
            }
            IoUtil.close((Closeable)os);
            IoUtil.close((Closeable)is);
        }
        return tmpfile;
    }

    public static void deleteTmpFile(File tmpfile) {
        if (tmpfile != null && tmpfile.exists()) {
            tmpfile.delete();
        }
    }
}

