/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filepreview.servlet;

import com.kdgcsoft.power.filepreview.FilePreviewManager;
import com.kdgcsoft.power.filepreview.provider.IPreviewProvider;
import com.kdgcsoft.power.filepreview.provider.PreviewInfo;
import com.kdgcsoft.power.filepreview.utils.EncodingDetect;
import com.kdgcsoft.power.filepreview.utils.ResourceUtil;
import com.xiaoleilu.hutool.lang.Base64;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreWebServlet
extends HttpServlet {
    private static final long serialVersionUID = 8560900844280078558L;
    private static Logger logger = LoggerFactory.getLogger(FileStoreWebServlet.class);
    private FilePreviewManager filePreviewManager;
    private static final String resourcePath = "com/kdgcsoft/power/filepreview/resource";
    private static final String INIT_PARAMS_FILE_PROVIDER = "previewProvider";

    public void init(ServletConfig servletConfig) throws ServletException {
        block10: {
            logger.info("\u521d\u59cb\u5316" + ((Object)((Object)this)).getClass().getName());
            String fileProviderClass = servletConfig.getInitParameter(INIT_PARAMS_FILE_PROVIDER);
            ServletRegistration reg = servletConfig.getServletContext().getServletRegistration(servletConfig.getServletName());
            Collection servletmapping = reg.getMappings();
            if (servletmapping == null || servletmapping.isEmpty()) {
                logger.error(String.valueOf(servletConfig.getServletName()) + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684servlet-mapping");
                return;
            }
            if (servletmapping.size() > 1) {
                logger.error(String.valueOf(servletConfig.getServletName()) + "\u4e0d\u652f\u6301\u914d\u7f6e\u591a\u4e2aservlet-mapping");
                return;
            }
            String servletvalue = this.fitServletKey((String)servletmapping.iterator().next());
            String servletKeyValue = String.valueOf(servletConfig.getServletContext().getContextPath()) + servletvalue;
            logger.info("fileProvider:" + fileProviderClass);
            logger.info("servletKey:" + servletKeyValue);
            if (fileProviderClass != null && fileProviderClass != "") {
                try {
                    Class<?> t = Class.forName(fileProviderClass);
                    if (IPreviewProvider.class.isAssignableFrom(t)) {
                        IPreviewProvider baseProvider = (IPreviewProvider)t.newInstance();
                        this.filePreviewManager = FilePreviewManager.init(baseProvider, servletKeyValue);
                        break block10;
                    }
                    logger.error("\u6587\u4ef6\u63d0\u4f9b\u7c7b:" + fileProviderClass + "\u9700\u8981\u5b9e\u73b0com.kdgcsoft.power.filepreview.provider.IPreviewProvider\u63a5\u53e3!");
                }
                catch (ClassNotFoundException e) {
                    logger.error("\u6587\u4ef6\u63d0\u4f9b\u7c7b:" + fileProviderClass + "\u672a\u627e\u5230!", (Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.error("\u6587\u4ef6\u63d0\u4f9b\u7c7b\u52a0\u8f7d\u51fa\u9519", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error("\u6587\u4ef6\u63d0\u4f9b\u7c7b\u52a0\u8f7d\u51fa\u9519", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u63d0\u4f9b\u7c7b\u52a0\u8f7d\u51fa\u9519", (Throwable)e);
                }
            } else {
                logger.error("\u8bf7\u914d\u7f6e\u6587\u4ef6\u63d0\u4f9b\u7c7b \u5b9e\u73b0com.kdgcsoft.power.filepreview.provider.IPreviewProvider \u63a5\u53e3");
            }
        }
        super.init();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream is;
        PreviewInfo fileinfo;
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = String.valueOf(contextPath) + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        logger.debug("uri:" + uri);
        logger.debug("path:" + path);
        if (path.startsWith("/css") || path.startsWith("/js")) {
            this.returnResourceFile(path, uri, response);
            return;
        }
        if (path.startsWith("/preview")) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            String html = this.filePreviewManager.getPreviewHtml(request);
            out.println(html);
            out.flush();
            out.close();
            return;
        }
        if (path.startsWith("/fileresource")) {
            if (this.isAuthored(request, "preview")) {
                fileinfo = this.filePreviewManager.getPreviewProvider().getPreviewInfo(request);
                is = this.filePreviewManager.getPreviewProvider().getPreviewStream(request);
                try {
                    int len;
                    if (ArrayUtil.containsIgnoreCase((CharSequence[])FilePreviewManager.textfile, (CharSequence)fileinfo.getViewtype())) {
                        int len2;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((len2 = is.read(buffer)) > -1) {
                            baos.write(buffer, 0, len2);
                        }
                        baos.flush();
                        ByteArrayInputStream stream1 = new ByteArrayInputStream(baos.toByteArray());
                        ByteArrayInputStream stream2 = new ByteArrayInputStream(baos.toByteArray());
                        String charset = EncodingDetect.detect(stream1);
                        response.setContentType("text/plain; charset=" + charset);
                        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                        while ((len2 = stream2.read(buffer)) != -1) {
                            out.write(buffer, 0, len2);
                        }
                        out.flush();
                        ((InputStream)stream1).close();
                        ((InputStream)stream2).close();
                        is.close();
                        return;
                    }
                    BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] buffer = new byte[1024];
                    while ((len = is.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    is.close();
                    return;
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u6d41\u8bfb\u53d6\u51fa\u9519", (Throwable)e);
                }
            } else {
                PrintWriter out = response.getWriter();
                out.println("\u6ca1\u6709\u9884\u89c8\u6743\u9650");
                out.flush();
                out.close();
                return;
            }
        }
        if (path.startsWith("/download")) {
            if (this.isAuthored(request, "download")) {
                int len;
                fileinfo = this.filePreviewManager.getPreviewProvider().getPreviewInfo(request);
                is = this.filePreviewManager.getPreviewProvider().getDownloadStream(request);
                response.addHeader("Content-Length", "" + fileinfo.getFileLength());
                response.setContentType("application/x-download");
                response.addHeader("Content-Disposition", "attachment;filename=" + this.fileNameEncoding(fileinfo.getFileName(), request));
                BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
                is.close();
                return;
            }
            this.returnResourceFile("/html/nopromission.html", uri, response);
            return;
        }
    }

    public boolean isAuthored(HttpServletRequest request, String authorType) {
        if ("preview".equals(authorType)) {
            return this.filePreviewManager.getPreviewProvider().canPreview(request);
        }
        if ("download".equals(authorType)) {
            return this.filePreviewManager.getPreviewProvider().canDownload(request);
        }
        return false;
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        String filePath = resourcePath + fileName;
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        } else if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        } else {
            if (fileName.endsWith(".jpg") || fileName.endsWith(".png")) {
                byte[] bytes = ResourceUtil.readByteArrayFromResource(filePath);
                if (bytes != null) {
                    response.getOutputStream().write(bytes);
                }
                return;
            }
            if (fileName.endsWith(".swf")) {
                response.setContentType("application/x-shockwave-flash");
                byte[] bytes = ResourceUtil.readByteArrayFromResource(filePath);
                if (bytes != null) {
                    response.getOutputStream().write(bytes);
                }
                return;
            }
        }
        String text = ResourceUtil.readFromResource(filePath);
        if (text == null) {
            response.sendRedirect(String.valueOf(uri) + "/index.html");
            return;
        }
        response.getWriter().write(text);
    }

    protected String fitServletKey(String urlpattern) {
        urlpattern = StrUtil.subPre((CharSequence)urlpattern, (int)urlpattern.lastIndexOf("/"));
        return urlpattern;
    }

    public String fileNameEncoding(String fileName, HttpServletRequest request) throws IOException {
        String agent = request.getHeader("User-Agent");
        fileName = agent.contains("Firefox") ? "=?utf-8?B?" + Base64.encode((byte[])fileName.getBytes("utf-8")) + "?=" : URLEncoder.encode(fileName, "utf-8");
        return fileName;
    }
}

