package com.kdgcsoft.power.filepreview.servlet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Collection;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kdgcsoft.power.filepreview.FilePreviewManager;
import com.kdgcsoft.power.filepreview.provider.IPreviewProvider;
import com.kdgcsoft.power.filepreview.provider.PreviewInfo;
import com.kdgcsoft.power.filepreview.utils.EncodingDetect;
import com.kdgcsoft.power.filepreview.utils.ResourceUtil;
import com.xiaoleilu.hutool.lang.Base64;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.StrUtil;


public class FileStoreWebServlet extends HttpServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 8560900844280078558L;
	private static Logger logger = LoggerFactory.getLogger(FileStoreWebServlet.class);
	private  FilePreviewManager filePreviewManager;
	private static final String resourcePath = "com/kdgcsoft/power/filepreview/resource";
	private static final String INIT_PARAMS_FILE_PROVIDER = "previewProvider";
	
	
	public void init(ServletConfig servletConfig) throws ServletException {
		logger.info("初始化"+this.getClass().getName());
		String fileProviderClass =servletConfig.getInitParameter(INIT_PARAMS_FILE_PROVIDER);
		ServletRegistration reg=servletConfig.getServletContext().getServletRegistration(servletConfig.getServletName());
		Collection<String> servletmapping=reg.getMappings();
		if(servletmapping==null||servletmapping.isEmpty()) {
			logger.error(servletConfig.getServletName()+"没有找到对应的servlet-mapping");
			return;
		}
		if(servletmapping.size()>1) {
			logger.error(servletConfig.getServletName()+"不支持配置多个servlet-mapping");
			return;
		}
		
		String servletvalue=fitServletKey(servletmapping.iterator().next());
		String servletKeyValue =servletConfig.getServletContext().getContextPath()+servletvalue;
		logger.info("fileProvider:"+fileProviderClass);
		logger.info("servletKey:"+servletKeyValue);
				if (fileProviderClass != null && fileProviderClass != "") {
					try {
						Class<?> t = Class.forName(fileProviderClass);
						// 检查是否是IPreviewProvider的实现类
						if (IPreviewProvider.class.isAssignableFrom(t)) {
							IPreviewProvider baseProvider = (IPreviewProvider) t.newInstance();
							filePreviewManager=FilePreviewManager.init(baseProvider,servletKeyValue);
						} else {
							logger.error("文件提供类:" + fileProviderClass+ "需要实现com.kdgcsoft.power.filepreview.provider.IPreviewProvider接口!");
						}
					} catch (ClassNotFoundException e) {
						logger.error("文件提供类:" + fileProviderClass + "未找到!",e);
					} catch (InstantiationException e) {
						logger.error("文件提供类加载出错", e);
					} catch (IllegalAccessException e) {
						logger.error("文件提供类加载出错", e);
					} catch (IOException e) {
						logger.error("文件提供类加载出错", e);
					}
				} else {
					logger.error("请配置文件提供类 实现com.kdgcsoft.power.filepreview.provider.IPreviewProvider 接口");
				}
		super.init();
		
	}

	@Override
	public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String contextPath = request.getContextPath();
		String servletPath = request.getServletPath();
		String requestURI = request.getRequestURI();
		response.setCharacterEncoding("utf-8");
		if (contextPath == null) { // root context
			contextPath = "";
		}
		String uri = contextPath + servletPath;
		String path = requestURI.substring(contextPath.length() + servletPath.length());
		logger.debug("uri:"+uri);
		logger.debug("path:"+path);
		//css资源及js资源直接返回对应的资源文件
		if (path.startsWith("/css") || path.startsWith("/js")) {
			returnResourceFile(path,uri,response);
			return;
		}
		//预览请求返回对应的html页面
		if(path.startsWith("/preview")) {
			response.setContentType("text/html");
			PrintWriter out = response.getWriter();
			String html=filePreviewManager.getPreviewHtml(request);
			out.println(html);
			out.flush();
			out.close();
			return ;
		}
		
		//提供预览的文件资源
		if(path.startsWith("/fileresource")) {
			if(isAuthored(request,AuthorType.PREVIEW)) {
				PreviewInfo fileinfo=filePreviewManager.getPreviewProvider().getPreviewInfo(request);
				InputStream is=filePreviewManager.getPreviewProvider().getPreviewStream(request);
				BufferedOutputStream out;
				try {
					//文本文件会根据文件的编码添加文件头防止页面预览时出现乱码问题
					if(ArrayUtil.containsIgnoreCase(FilePreviewManager.textfile, fileinfo.getViewtype())) {
						ByteArrayOutputStream baos = new ByteArrayOutputStream();  
						byte[] buffer = new byte[1024];  
						int len;  
						while ((len = is.read(buffer)) > -1 ) {  
						    baos.write(buffer, 0, len);  
						}  
						baos.flush();
						
						InputStream stream1 = new ByteArrayInputStream(baos.toByteArray());  
						InputStream stream2 = new ByteArrayInputStream(baos.toByteArray());  
						String charset= EncodingDetect.detect(stream1);
						response.setContentType("text/plain; charset="+charset);//如果是预览文本类型的文件要设置编码
						out = new BufferedOutputStream(response.getOutputStream());
						while ((len = stream2.read(buffer)) != -1) {
							out.write(buffer, 0, len);
						}
						out.flush();
						stream1.close();
						stream2.close();
						is.close();
						return;
					}else {
						out = new BufferedOutputStream(response.getOutputStream());
						byte[] buffer = new byte[1024];
						int len;
						while ((len = is.read(buffer)) != -1) {
							out.write(buffer, 0, len);
						}
						out.flush();
						is.close();
						return;
					}
				} catch (IOException e) {
					logger.error("文件流读取出错", e);
				}
			}else {
				PrintWriter out = response.getWriter();
				out.println("没有预览权限");
				out.flush();
				out.close();
				return ;
			}
		}
		
		
		//提供原始文件的下载
		if(path.startsWith("/download")) {
			if(isAuthored(request,AuthorType.DOWNLOAD)) {//允许下载
				PreviewInfo fileinfo=filePreviewManager.getPreviewProvider().getPreviewInfo(request);
				InputStream is=filePreviewManager.getPreviewProvider().getDownloadStream(request);
				response.addHeader("Content-Length", "" + fileinfo.getFileLength());
				response.setContentType("application/x-download");
				response.addHeader("Content-Disposition", "attachment;filename=" + fileNameEncoding(fileinfo.getFileName(),request));
				BufferedOutputStream out;
				out = new BufferedOutputStream(response.getOutputStream());
				byte[] buffer = new byte[1024];
				int len;
				while ((len = is.read(buffer)) != -1) {
					out.write(buffer, 0, len);
				}
				out.flush();
				is.close();
				return;
			}else {
				returnResourceFile("/html/nopromission.html",uri,response);
				return ;
			}
		}

		
	}
	/**
	 * 检查是否有对应类型的访问权限
	 * @param request
	 * @param authorType 
	 * @return 是否拥有权限
	 */
	public boolean isAuthored(HttpServletRequest request, String authorType) {
		if (AuthorType.PREVIEW.equals(authorType)) {// 检查预览权限
			return filePreviewManager.getPreviewProvider().canPreview(request);
		} else if (AuthorType.DOWNLOAD.equals(authorType)) {// 检查下载权限
			return filePreviewManager.getPreviewProvider().canDownload(request);
		} else {
			return false;
		}
	}
/***
 * 返回静态资源文件
 * @param fileName 文件名 如 juqery.js
 * @param uri 文件路径
 * @param response
 * @throws ServletException
 * @throws IOException
 */
	protected void returnResourceFile(String fileName, String uri, HttpServletResponse response)
			throws ServletException, IOException {

		String filePath = resourcePath+fileName;
		
		//不同的资源后缀采用不同的方式返回请求头和资源内容
		if (filePath.endsWith(".html")) {
			response.setContentType("text/html; charset=utf-8");
		}else if (fileName.endsWith(".css")) {
			response.setContentType("text/css;charset=utf-8");
		} else if (fileName.endsWith(".js")) {
			response.setContentType("text/javascript;charset=utf-8");
		}else if (fileName.endsWith(".jpg")||fileName.endsWith(".png")) {
			byte[] bytes = ResourceUtil.readByteArrayFromResource(filePath);
			if (bytes != null) {
				response.getOutputStream().write(bytes);
			}
			return;
		}else if (fileName.endsWith(".swf")) {
			response.setContentType("application/x-shockwave-flash");
			byte[] bytes = ResourceUtil.readByteArrayFromResource(filePath);
			if (bytes != null) {
				response.getOutputStream().write(bytes);
			}
			return;
		}

		String text = ResourceUtil.readFromResource(filePath);
		if (text == null) {
			response.sendRedirect(uri + "/index.html");
			return;
		}
		
		response.getWriter().write(text);
	}
	/**
	 * 匹配出Servlet的key 
	 * @param urlpattern Servlet配置的路径
	 * @return 匹配后的路径前缀
	 */
	protected String fitServletKey(String urlpattern) {
		urlpattern=StrUtil.subPre(urlpattern, urlpattern.lastIndexOf("/"));//截取出servlet的匹配路径
		return urlpattern;
	}
	
	public String fileNameEncoding(String fileName, HttpServletRequest request)  
            throws IOException {  
        String agent = request.getHeader("User-Agent");  
        if (agent.contains("Firefox")) {  
            fileName = "=?utf-8?B?" + Base64.encode(fileName.getBytes("utf-8")) + "?=";  
        } else {  
            fileName = URLEncoder.encode(fileName, "utf-8");  
        }  
        return fileName;  
    }  

}
