package com.kdgcsoft.power.filepreview.provider;

import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

public interface IPreviewProvider {
	/**
	 * 是否拥有预览权限
	 * @param request
	 * @return 返回是否拥有预览权限
	 */
	public boolean canPreview(HttpServletRequest request);
	/**
	 * 是否拥有下载权限
	 * @param request
	 * @return 返回是否拥有下载权限
	 */
	public boolean canDownload(HttpServletRequest request);
	/**
	 * 获得原始文件下载的stream
	 * @param request
	 * @return 返回原始文件的InputStream
	 */
	public InputStream getDownloadStream(HttpServletRequest request);
	/**
	 * 获得文件预览资源的stream
	 * @param request
	 * @return 返回预览文件的InputStream
	 */
	public InputStream getPreviewStream(HttpServletRequest request);
	/**
	 * 获得文件的基本信息,可以不包含stream信息
	 * @param request
	 * @return 返回文件的预览信息
	 */
	public PreviewInfo getPreviewInfo(HttpServletRequest request);
	/**
	 * 在预览页面构建更多的操作按钮的接口 返回PreviewBtn数组
	 * @param request
	 * @return 返回 List<PreviewBtn> 是所有更多操作的列表
	 */
	public List<PreviewBtn> morePreviewBtn(HttpServletRequest request);
}
