/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filepreview.utils;

import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import com.kdgcsoft.power.filepreview.utils.ResourceUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class CompressFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> readZipFile(InputStream is, String viewtype) {
        ArrayList<Map<String, String>> filelist;
        block17: {
            block18: {
                filelist = new ArrayList<Map<String, String>>();
                if (!"zip".equalsIgnoreCase(viewtype) && !"jar".equalsIgnoreCase(viewtype)) break block18;
                File tmpfile = CompressFileReader.StreamToTmpFile(is);
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(tmpfile, ResourceUtil.getFileEncodeUTFGBK(tmpfile.getAbsolutePath()));
                    Enumeration entries = zipFile.getEntries();
                    while (entries.hasMoreElements()) {
                        ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                        HashMap<String, String> fileinfo = new HashMap<String, String>();
                        fileinfo.put("filename", entry.getName());
                        fileinfo.put("filesize", CompressFileReader.getDataSize(entry.getCompressedSize()));
                        filelist.add(fileinfo);
                    }
                    IOUtils.closeQuietly((Closeable)zipFile);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    break block17;
                }
                finally {
                    IOUtils.closeQuietly(zipFile);
                    CompressFileReader.deleteTmpFile(tmpfile);
                }
                CompressFileReader.deleteTmpFile(tmpfile);
                break block17;
            }
            if ("tar".equalsIgnoreCase(viewtype)) {
                TarArchiveInputStream tarIn = new TarArchiveInputStream(is, 2048);
                TarArchiveEntry entry = null;
                try {
                    while ((entry = tarIn.getNextTarEntry()) != null) {
                        HashMap<String, String> fileinfo = new HashMap<String, String>();
                        fileinfo.put("filename", entry.getName());
                        fileinfo.put("filesize", CompressFileReader.getDataSize(entry.getSize()));
                        filelist.add(fileinfo);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if ("7z".equalsIgnoreCase(viewtype)) {
                File tmpfile = CompressFileReader.StreamToTmpFile(is);
                SevenZFile sevenZFile = null;
                try {
                    sevenZFile = new SevenZFile(tmpfile);
                    SevenZArchiveEntry entry = null;
                    while ((entry = sevenZFile.getNextEntry()) != null) {
                        HashMap<String, String> fileinfo = new HashMap<String, String>();
                        fileinfo.put("filename", entry.getName());
                        fileinfo.put("filesize", CompressFileReader.getDataSize(entry.getSize()));
                        filelist.add(fileinfo);
                    }
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(sevenZFile);
                        CompressFileReader.deleteTmpFile(tmpfile);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)sevenZFile);
                    CompressFileReader.deleteTmpFile(tmpfile);
                }
                IOUtils.closeQuietly((Closeable)sevenZFile);
                CompressFileReader.deleteTmpFile(tmpfile);
            }
        }
        return filelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> readRarFile(InputStream is) {
        ArrayList<Map<String, String>> filelist = new ArrayList<Map<String, String>>();
        File tmpfile = CompressFileReader.StreamToTmpFile(is);
        Archive archive = null;
        try {
            archive = new Archive(tmpfile);
            List<FileHeader> headers = archive.getFileHeaders();
            headers = CompressFileReader.sortedHeaders(headers);
            for (FileHeader header : headers) {
                HashMap<String, String> fileinfo = new HashMap<String, String>();
                String fullName = header.isUnicode() ? header.getFileNameW() : header.getFileNameString();
                fileinfo.put("filename", fullName);
                fileinfo.put("filesize", CompressFileReader.getDataSize(header.getDataSize()));
                filelist.add(fileinfo);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                archive.close();
                CompressFileReader.deleteTmpFile(tmpfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filelist;
    }

    public static List<FileHeader> sortedHeaders(List<FileHeader> headers) {
        ArrayList<FileHeader> sortedHeaders = new ArrayList<FileHeader>();
        TreeMap<Integer, FileHeader> mapHeaders = new TreeMap<Integer, FileHeader>();
        for (FileHeader fileHeader : headers) {
            mapHeaders.put(fileHeader.getFileNameW().length(), fileHeader);
        }
        for (Map.Entry entry : mapHeaders.entrySet()) {
            for (FileHeader header : headers) {
                if (((Integer)entry.getKey()).intValue() != header.getFileNameW().length()) continue;
                sortedHeaders.add(header);
            }
        }
        return sortedHeaders;
    }

    public static String getDataSize(long size) {
        DecimalFormat formater = new DecimalFormat("####.00");
        if (size <= 0L) {
            return "";
        }
        if (size < 1024L) {
            return size + "bytes";
        }
        if (size < 0x100000L) {
            float kbsize = (float)size / 1024.0f;
            return formater.format(kbsize) + "KB";
        }
        if (size < 0x40000000L) {
            float mbsize = (float)size / 1024.0f / 1024.0f;
            return formater.format(mbsize) + "MB";
        }
        if (size < 0L) {
            float gbsize = (float)size / 1024.0f / 1024.0f / 1024.0f;
            return formater.format(gbsize) + "GB";
        }
        return "size: error";
    }

    public static File StreamToTmpFile(InputStream is) {
        Long time = System.currentTimeMillis();
        File tmpdir = new File("D:/tmp/");
        File tmpfile = null;
        try {
            tmpdir.mkdir();
            tmpfile = new File(tmpdir.getAbsolutePath() + "\\temp" + time + ".tmp");
            tmpfile.createNewFile();
            FileOutputStream os = new FileOutputStream(tmpfile);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmpfile;
    }

    public static void deleteTmpFile(File tmpfile) {
        if (tmpfile.exists()) {
            tmpfile.delete();
        }
    }
}

