/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.power.filepreview;

import com.kdgcsoft.power.filepreview.provider.BaseFileProvider;
import com.kdgcsoft.power.filepreview.provider.FileInfo;
import com.kdgcsoft.power.filepreview.provider.PreviewBtn;
import com.kdgcsoft.power.filepreview.utils.CompressFileReader;
import com.xiaoleilu.hutool.util.ArrayUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePreviewManager {
    private static Logger logger = LoggerFactory.getLogger(FilePreviewManager.class);
    public static final String[] zipfile = new String[]{"zip", "jar", "tar", "7z"};
    public static final String[] rarfile = new String[]{"rar"};
    public static final String[] pdffile = new String[]{"pdf", "html"};
    public static final String[] audiofile = new String[]{"mp3", "m4a"};
    public static final String[] videofile = new String[]{"m4v", "webm", "ogv", "mp4"};
    public static final String[] textfile = new String[]{"txt", "sql", "ini", "properties", "log", "js", "css", "json", "java", "md", "ini", "xml"};
    public static final String[] imgfile = new String[]{"img", "png", "jpg", "bmp", "jpeg", "gif", "ico"};
    private static final String templatePath = "com/kdgcsoft/power/filepreview/resource/template";
    private static FilePreviewManager instance;
    private BaseFileProvider provider;
    private GroupTemplate gt;
    private String contextPath;

    public static FilePreviewManager init(BaseFileProvider provider, String contextPath) throws IOException {
        if (instance == null) {
            instance = new FilePreviewManager(provider, contextPath);
        }
        return instance;
    }

    public static FilePreviewManager get() throws IOException {
        if (instance == null) {
            logger.error("FilePreviewManager\u6ca1\u6709\u521d\u59cb\u5316,\u8bf7\u68c0\u67e5web.xml\u4e2d\u662f\u5426\u914d\u7f6e\u4e86servlet \u53caload-on-startup=1");
            return null;
        }
        return instance;
    }

    public FilePreviewManager(BaseFileProvider provider, String contextPath) throws IOException {
        this.provider = provider;
        this.contextPath = contextPath;
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        Configuration cfg = Configuration.defaultConfiguration();
        this.gt = new GroupTemplate((ResourceLoader)resourceLoader, cfg);
    }

    public BaseFileProvider getProvider() {
        return this.provider;
    }

    public void setProvider(BaseFileProvider provider) {
        this.provider = provider;
    }

    public String getPreviewHtml(HttpServletRequest request) {
        String html = "";
        String queryString = request.getQueryString();
        if (this.provider.canPreview(request)) {
            FileInfo fileinfo = this.provider.getFileInfo(request);
            logger.debug("fileinfo:" + fileinfo);
            boolean candownload = this.provider.canDownload(request);
            logger.debug("\u4e0b\u8f7d\u6743\u9650:" + candownload);
            List<PreviewBtn> btnlist = this.provider.morePreviewBtn(request);
            logger.debug("\u6784\u9020\u66f4\u591a\u6309\u94ae:" + btnlist);
            Template t = null;
            if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])pdffile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_pdf.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_pdf.btl");
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])textfile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_txt.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_txt.btl");
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])imgfile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_img.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_img.btl");
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])audiofile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_audio.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_audio.btl");
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])videofile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_video.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_video.btl");
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])zipfile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_compress.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_compress.btl");
                fileinfo = this.provider.getFilePreviewStream(request);
                List<Map<String, String>> filelist = CompressFileReader.readZipFile(fileinfo.getPreviewStream(), fileinfo.getViewtype());
                t.binding("filelist", filelist);
            } else if (!fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])rarfile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_compress.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_compress.btl");
                fileinfo = this.provider.getFilePreviewStream(request);
                List<Map<String, String>> filelist = CompressFileReader.readRarFile(fileinfo.getPreviewStream());
                t.binding("filelist", filelist);
            } else if (fileinfo.isMultiView() && ArrayUtil.containsIgnoreCase((CharSequence[])imgfile, (CharSequence)fileinfo.getViewtype())) {
                logger.debug("\u4f7f\u7528\u6a21\u7248preview_mulitimg.btl");
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/preview_mulitimg.btl");
            } else {
                logger.debug("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b:" + fileinfo.getViewtype());
                t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/notsupport.btl");
            }
            t.binding("ctx", (Object)this.contextPath);
            t.binding("queryString", (Object)queryString);
            t.binding("fileinfo", (Object)fileinfo);
            t.binding("candownload", (Object)candownload);
            t.binding("btnlist", btnlist);
            html = t.render();
        } else {
            logger.debug("\u6ca1\u6709\u9884\u89c8\u6743\u9650");
            Template t = this.gt.getTemplate("com/kdgcsoft/power/filepreview/resource/template/nopromission.btl");
            t.binding("ctx", (Object)this.contextPath);
            t.binding("queryString", (Object)queryString);
            html = t.render();
        }
        return html;
    }
}

