package com.kdgcsoft.power.filepreview.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import com.xiaoleilu.hutool.io.FileUtil;

public class CompressFileReader {

    public static List<Map<String,String>> readZipFile(InputStream is,String viewtype) {
    	List<Map<String,String>> filelist=new ArrayList<Map<String,String>>();
    	if("zip".equalsIgnoreCase(viewtype)||"jar".equalsIgnoreCase(viewtype)) {
    		File tmpfile=StreamToTmpFile(is);
    		ZipFile zipFile=null ;
        	try {
        		zipFile= new ZipFile(tmpfile,ResourceUtil.getFileEncodeUTFGBK(tmpfile.getAbsolutePath()));
    			 Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
    			 while (entries.hasMoreElements()){
    				 ZipArchiveEntry entry = entries.nextElement();
    				 Map<String,String> fileinfo=new HashMap<String,String>();
    				fileinfo.put("filename", entry.getName());
    				fileinfo.put("filesize", getDataSize(entry.getCompressedSize()));
    			    filelist.add(fileinfo);
    			 }
    		} catch (IOException e1) {
    			e1.printStackTrace();
    		}finally {
    			IOUtils.closeQuietly(zipFile);
    			deleteTmpFile(tmpfile);
    		}
    	}else if("tar".equalsIgnoreCase(viewtype)) {
    		TarArchiveInputStream tarIn = new TarArchiveInputStream(is, 2048);
    		TarArchiveEntry entry = null; 
    		try {
				while ((entry = tarIn.getNextTarEntry()) != null) {
					 Map<String,String> fileinfo=new HashMap<String,String>();
	    				fileinfo.put("filename", entry.getName());
	    				fileinfo.put("filesize", getDataSize(entry.getSize()));
	    			    filelist.add(fileinfo);
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}else if("7z".equalsIgnoreCase(viewtype)) {
    		File tmpfile=StreamToTmpFile(is);
    		SevenZFile sevenZFile =null;
    		try {
    			sevenZFile = new SevenZFile(tmpfile);
        		SevenZArchiveEntry entry = null; 
				while ((entry = sevenZFile.getNextEntry()) != null) {
					 Map<String,String> fileinfo=new HashMap<String,String>();
	    				fileinfo.put("filename", entry.getName());
	    				fileinfo.put("filesize", getDataSize(entry.getSize()));
	    			    filelist.add(fileinfo);
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}finally {
				IOUtils.closeQuietly(sevenZFile);
				deleteTmpFile(tmpfile);
			}
    	}
    	
    	 return filelist;
    }
    
    public static List<Map<String,String>> readRarFile(InputStream is){
    	List<Map<String,String>> filelist=new ArrayList<Map<String,String>>();
    	File tmpfile=StreamToTmpFile(is);
    	Archive archive=null;
    	try {
    		archive=new Archive(tmpfile);
				List<FileHeader> headers = archive.getFileHeaders();
				 headers = sortedHeaders(headers);
				 for (FileHeader header : headers) {
					Map<String,String> fileinfo=new HashMap<String,String>();
					String fullName;
	                if (header.isUnicode()) {
	                    fullName = header.getFileNameW();
	                }else {
	                    fullName = header.getFileNameString();
	                }
					
					fileinfo.put("filename", fullName);
					fileinfo.put("filesize", getDataSize(header.getDataSize()));
				    filelist.add(fileinfo);
				 }
		} catch (Exception e1) {
			e1.printStackTrace();
		}finally{
				try {
					archive.close();
					deleteTmpFile(tmpfile);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
		}
    	
    	 return filelist;
    }
    
    public static  List<FileHeader> sortedHeaders(List<FileHeader> headers) {
        List<FileHeader> sortedHeaders = new ArrayList<>();
        Map<Integer, FileHeader> mapHeaders = new TreeMap<>();
        for(FileHeader header:headers){
        	mapHeaders.put(header.getFileNameW().length(), header);
        }
        for (Map.Entry<Integer, FileHeader> entry : mapHeaders.entrySet()){
            for (FileHeader header : headers) {
                if (entry.getKey().intValue() == header.getFileNameW().length()) {
                    sortedHeaders.add(header);
                }
            }
        }
        return sortedHeaders;
    }
    
    public static String getDataSize(long size){  
        DecimalFormat formater = new DecimalFormat("####.00");  
        if(size<=0){  
            return "";  
        }else if(size<1024){  
            return size+"bytes";  
        }else if(size<1024*1024){  
            float kbsize = size/1024f;    
            return formater.format(kbsize)+"KB";  
        }else if(size<1024*1024*1024){  
            float mbsize = size/1024f/1024f;    
            return formater.format(mbsize)+"MB";  
        }else if(size<1024*1024*1024*1024){  
            float gbsize = size/1024f/1024f/1024f;    
            return formater.format(gbsize)+"GB";  
        }else{  
            return "size: error";  
        }  
    }
    
    public static File StreamToTmpFile(InputStream is) {
    	Long time=System.currentTimeMillis();
    	File tmpdir=new File("D:/tmp/");
    	File tmpfile=null;
    	 try {
    		 tmpdir.mkdir();
    		 tmpfile=new File(tmpdir.getAbsolutePath()+"\\temp"+time+".tmp");
    		 tmpfile.createNewFile();
    		   OutputStream os = new FileOutputStream(tmpfile);
    		   int bytesRead = 0;
    		   byte[] buffer = new byte[8192];
    		   while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
    		    os.write(buffer, 0, bytesRead);
    		   }
    		   os.close();
    		   is.close();
    		  } catch (Exception e) {
    		   e.printStackTrace();
    		  }
    	 return tmpfile;
    }
    
    public static void  deleteTmpFile(File tmpfile) {
    	if(tmpfile.exists()) {
    		tmpfile.delete();
    	}
    }
}
