package com.kdgcsoft.power.filepreview.provider;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

public interface BaseFileProvider {
	/**
	 * 是否拥有预览权限
	 * @param request
	 * @return
	 */
	public boolean canPreview(HttpServletRequest request);
	/**
	 * 是否拥有下载权限
	 * @param request
	 * @return
	 */
	public boolean canDownload(HttpServletRequest request);
	/**
	 * 获得原始文件下载的stream
	 * @param request
	 * @return
	 */
	public FileInfo getFileDownloadStream(HttpServletRequest request);
	/**
	 * 获得文件预览资源的stream
	 * @param request
	 * @return
	 */
	public FileInfo getFilePreviewStream(HttpServletRequest request);
	/**
	 * 获得文件的基本信息,可以不包含stream信息
	 * @param request
	 * @return
	 */
	public FileInfo getFileInfo(HttpServletRequest request);
	/**
	 * 在预览页面构建更多的操作按钮的接口 返回PreviewBtn数组
	 * @param request
	 * @return
	 */
	public List<PreviewBtn> morePreviewBtn(HttpServletRequest request);
}
