/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.pojo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.util.SimpleTableDef;

public final class ObjectTableDataProvider<E>
implements TableDataProvider<E> {
    private static final long serialVersionUID = 1L;
    private final String _tableName;
    private final Collection<E> _collection;
    private final Class<E> _class;
    private final SimpleTableDef _tableDef;
    private final Map<String, Class<?>> _fieldTypes;

    public ObjectTableDataProvider(Class<E> cls) {
        this(cls.getSimpleName(), cls);
    }

    public ObjectTableDataProvider(String tableName, Class<E> cls) {
        this(tableName, cls, new ArrayList());
    }

    public ObjectTableDataProvider(String tableName, Class<E> cls, Collection<E> collection) {
        this._tableName = tableName;
        this._collection = collection;
        this._class = cls;
        this._fieldTypes = new HashMap();
        this._tableDef = this.createTableDef();
    }

    public String getName() {
        return this._tableName;
    }

    @Override
    public Iterator<E> iterator() {
        return this._collection.iterator();
    }

    @Override
    public SimpleTableDef getTableDef() {
        return this._tableDef;
    }

    private SimpleTableDef createTableDef() {
        Method[] methods;
        TreeMap<String, ColumnType> columns = new TreeMap<String, ColumnType>();
        Method[] methodArray = methods = this._class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> returnType;
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.startsWith("get") && !"getClass".equals(methodName) && method.getParameterTypes().length == 0 && (returnType = method.getReturnType()) != null) {
                String columnName = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                this._fieldTypes.put(columnName, returnType);
                ColumnType columnType = ColumnTypeImpl.convertColumnType(returnType);
                columns.put(columnName, columnType);
            }
            ++n2;
        }
        int size = columns.size();
        String[] columnNames = new String[size];
        ColumnType[] columnTypes = new ColumnType[size];
        Set entrySet = columns.entrySet();
        int i = 0;
        for (Map.Entry entry : entrySet) {
            columnNames[i] = (String)entry.getKey();
            columnTypes[i] = (ColumnType)entry.getValue();
            ++i;
        }
        return new SimpleTableDef(this._tableName, columnNames, columnTypes);
    }

    @Override
    public Object getValue(String column, E record) {
        Method getterMethod = this.getMethod(column, "get", new Class[0]);
        try {
            Object result = getterMethod.invoke(record, new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to invoke getter method: " + getterMethod, e);
        }
    }

    @Override
    public void insert(Map<String, Object> recordData) {
        E object;
        try {
            object = this._class.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate a new instance of " + this._class, e);
        }
        Set<Map.Entry<String, Object>> entrySet = recordData.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String column = entry.getKey();
            Class<?> fieldType = this._fieldTypes.get(column);
            Method setterMethod = this.getMethod(column, "set", fieldType);
            Object value = entry.getValue();
            try {
                setterMethod.invoke(object, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke setter method: " + setterMethod, e);
            }
        }
        this._collection.add(object);
    }

    private Method getMethod(String column, String prefix, Class<?> ... parameterTypes) {
        Method getterMethod;
        try {
            getterMethod = this._class.getMethod(String.valueOf(prefix) + Character.toUpperCase(column.charAt(0)) + column.substring(1), parameterTypes);
        }
        catch (Exception e) {
            try {
                getterMethod = this._class.getMethod(String.valueOf(prefix) + column, parameterTypes);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Could not find '" + prefix + "' method for column: " + column);
            }
        }
        return getterMethod;
    }
}

