/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.cassandra;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;

public class CassandraUtils {
    public static Row toRow(com.datastax.driver.core.Row dbObject, DataSetHeader header) {
        if (dbObject == null) {
            return null;
        }
        int size = header.size();
        Object[] values = new Object[size];
        int i = 0;
        while (i < values.length) {
            SelectItem selectItem = header.getSelectItem(i);
            String key = selectItem.getColumn().getName();
            values[i] = CassandraUtils.getColumnValue(key, dbObject);
            ++i;
        }
        return new DefaultRow(header, values);
    }

    private static Object getColumnValue(String columnName, com.datastax.driver.core.Row row) {
        ColumnDefinitions columns = row.getColumnDefinitions();
        DataType columnType = columns.getType(columnName);
        switch (columnType.getName()) {
            case BIGINT: {
                return row.getVarint(columnName);
            }
            case COUNTER: {
                return row.getLong(columnName);
            }
            case BLOB: {
                return row.getBytes(columnName);
            }
            case BOOLEAN: {
                return row.getBool(columnName);
            }
            case DECIMAL: {
                return row.getDecimal(columnName);
            }
            case DOUBLE: {
                return row.getDouble(columnName);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(columnName));
            }
            case INT: {
                return row.getInt(columnName);
            }
            case TEXT: {
                return row.getString(columnName);
            }
            case TIMESTAMP: {
                return row.getTimestamp(columnName);
            }
            case UUID: {
                return row.getUUID(columnName);
            }
            case VARCHAR: {
                return row.getString(columnName);
            }
            case VARINT: {
                return row.getVarint(columnName);
            }
            case LIST: {
                return row.getList(columnName, List.class);
            }
            case MAP: {
                return row.getMap(columnName, Map.class, String.class);
            }
            case SET: {
                return row.getSet(columnName, Set.class);
            }
            case INET: {
                return row.getInet(columnName);
            }
        }
        return row.getString(columnName);
    }
}

