/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.cassandra.CassandraDataSet;
import org.apache.metamodel.cassandra.CassandraUtils;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataContext
extends QueryPostprocessDataContext
implements DataContext {
    private static final Logger logger = LoggerFactory.getLogger(CassandraDataContext.class);
    private final Cluster cassandraCluster;
    private final SimpleTableDef[] tableDefs;
    private final String keySpaceName;

    public CassandraDataContext(Cluster cluster, String keySpace, SimpleTableDef ... tableDefs) {
        super(false);
        this.cassandraCluster = cluster;
        this.keySpaceName = keySpace;
        this.tableDefs = tableDefs;
    }

    public CassandraDataContext(Cluster cluster, String keySpace) {
        this(cluster, keySpace, CassandraDataContext.detectSchema(cluster, keySpace));
    }

    public static SimpleTableDef[] detectSchema(Cluster cluster, String keyspaceName) {
        Metadata metadata = cluster.getMetadata();
        KeyspaceMetadata keyspace = metadata.getKeyspace(keyspaceName);
        if (keyspace == null) {
            throw new IllegalArgumentException("Keyspace '" + keyspaceName + "' does not exist in the database");
        }
        Collection tables = keyspace.getTables();
        SimpleTableDef[] result = new SimpleTableDef[tables.size()];
        int i = 0;
        for (TableMetadata tableMetaData : tables) {
            SimpleTableDef table;
            result[i] = table = CassandraDataContext.detectTable(tableMetaData);
            ++i;
        }
        return result;
    }

    public static SimpleTableDef detectTable(TableMetadata tableMetaData) {
        List columns = tableMetaData.getColumns();
        String[] columnNames = new String[columns.size()];
        ColumnType[] columnTypes = new ColumnType[columns.size()];
        int i = 0;
        for (ColumnMetadata column : columns) {
            columnNames[i] = column.getName();
            columnTypes[i] = CassandraDataContext.getColumnTypeFromMetaDataField(column.getType().getName());
            ++i;
        }
        return new SimpleTableDef(tableMetaData.getName(), columnNames, columnTypes);
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        SimpleTableDef[] simpleTableDefArray = this.tableDefs;
        int n = this.tableDefs.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleTableDef tableDef = simpleTableDefArray[n2];
            MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
            TableMetadata cassandraTable = this.cassandraCluster.getMetadata().getKeyspace(this.keySpaceName).getTable(table.getName());
            if (cassandraTable != null) {
                List primaryKeys = cassandraTable.getPrimaryKey();
                for (ColumnMetadata primaryKey : primaryKeys) {
                    MutableColumn column = (MutableColumn)table.getColumnByName(primaryKey.getName());
                    if (column != null) {
                        column.setPrimaryKey(true);
                    }
                    column.setNativeType(primaryKey.getType().getName().name());
                }
            }
            theSchema.addTable((Table)table);
            ++n2;
        }
        return theSchema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.keySpaceName;
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        Select query = QueryBuilder.select().all().from(this.keySpaceName, table.getName());
        if (this.limitMaxRowsIsSet(maxRows)) {
            query.limit(maxRows);
        }
        ResultSet resultSet = this.cassandraCluster.connect().execute((Statement)query);
        Iterator response = resultSet.iterator();
        return new CassandraDataSet(response, columns);
    }

    private boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        if (primaryKeyColumn.getType() == ColumnType.UUID && keyValue instanceof String) {
            keyValue = UUID.fromString(keyValue.toString());
        }
        Select.Selection select = QueryBuilder.select();
        for (SelectItem selectItem : selectItems) {
            Column column = selectItem.getColumn();
            assert (column != null);
            select = select.column(column.getName());
        }
        Select.Where statement = select.from(this.keySpaceName, table.getName()).where(QueryBuilder.eq((String)primaryKeyColumn.getName(), (Object)keyValue));
        com.datastax.driver.core.Row row = this.cassandraCluster.connect().execute((Statement)statement).one();
        return CassandraUtils.toRow(row, (DataSetHeader)new SimpleDataSetHeader(selectItems));
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            logger.debug("Not able to execute count query natively - resorting to query post-processing, which may be expensive");
            return null;
        }
        Select statement = QueryBuilder.select().countAll().from(this.keySpaceName, table.getName());
        com.datastax.driver.core.Row response = this.cassandraCluster.connect().execute((Statement)statement).one();
        return response.getLong(0);
    }

    private static ColumnType getColumnTypeFromMetaDataField(DataType.Name metaDataName) {
        switch (metaDataName) {
            case BIGINT: 
            case COUNTER: {
                return ColumnType.BIGINT;
            }
            case BLOB: {
                return ColumnType.BLOB;
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DECIMAL: {
                return ColumnType.DECIMAL;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case INT: {
                return ColumnType.INTEGER;
            }
            case TEXT: {
                return ColumnType.STRING;
            }
            case TIMESTAMP: {
                return ColumnType.TIMESTAMP;
            }
            case UUID: {
                return ColumnType.UUID;
            }
            case VARCHAR: {
                return ColumnType.VARCHAR;
            }
            case VARINT: {
                return ColumnType.BIGINT;
            }
            case LIST: {
                return ColumnType.LIST;
            }
            case MAP: {
                return ColumnType.MAP;
            }
            case CUSTOM: {
                return ColumnType.OTHER;
            }
            case INET: {
                return ColumnType.INET;
            }
            case SET: {
                return ColumnType.SET;
            }
        }
        return ColumnType.STRING;
    }
}

