/*
 * Decompiled with CFR 0.152.
 */
package com.kdgcsoft.plugin.collect.kafka.reader;

import com.alibaba.fastjson2.JSONObject;
import com.kdgcsoft.plugin.api.DataNumEstimateType;
import com.kdgcsoft.plugin.api.PluginContext;
import com.kdgcsoft.plugin.api.PluginType;
import com.kdgcsoft.plugin.api.data.IDataReadPlugin;
import com.kdgcsoft.plugin.api.message.MessageBoxWrapper;
import com.kdgcsoft.plugin.api.param.PluginParam;
import com.kdgcsoft.plugin.api.record.Item;
import com.kdgcsoft.plugin.api.record.ItemType;
import com.kdgcsoft.plugin.api.record.Record;
import com.kdgcsoft.plugin.collect.kafka.reader.KafkaReaderPluginParam;
import com.kdgcsoft.plugin.kafka.common.KafkaConnector;
import com.kdgcsoft.plugin.kafka.common.KafkaResourcePluginParam;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.pf4j.Plugin;
import org.pf4j.PluginWrapper;

public class KafkaReaderPlugin
extends Plugin {
    public KafkaReaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Extension
    public static class KafkaIDataReadPlugin
    extends MessageBoxWrapper
    implements IDataReadPlugin,
    ExtensionPoint {
        private static final int CAPACITY = 65536;
        private static final int MIN_BATCH_SIZE = 500;
        private KafkaConsumer<String, String> consumer;
        private BlockingQueue<String> queue;
        private AtomicInteger counter;
        private volatile boolean stopped;
        private ExecutorService es;
        private KafkaReaderPluginParam pluginParam;
        private ReadWriteLock readWriteLock;
        private boolean continuousListen;
        private PluginContext context;

        public void init(PluginContext context, PluginParam param) throws Exception {
            this.pluginParam = (KafkaReaderPluginParam)param;
            this.context = context;
            KafkaResourcePluginParam resourcePluginParam = (KafkaResourcePluginParam)context.resourcePluginParam(KafkaResourcePluginParam.class, this.pluginParam.getResourceCode());
            long connectBegin = System.currentTimeMillis();
            this.consumer = KafkaConnector.getConsumer((KafkaResourcePluginParam)resourcePluginParam);
            long connectEnd = System.currentTimeMillis();
            this.mb.sendResourceConnectInfo(context.flowCode(), context.taskCode(), context.jobCode(), this.pluginParam.getResourceCode());
            this.mb.writeLog("\u8fde\u63a5Kafka Consumer\u8017\u65f6: {}ms", new Object[]{connectEnd - connectBegin});
            this.consumer.subscribe(Collections.singletonList(this.pluginParam.getTopic()));
            this.queue = new ArrayBlockingQueue<String>(65536);
            this.counter = new AtomicInteger(0);
            this.readWriteLock = new ReentrantReadWriteLock();
            this.es = Executors.newSingleThreadExecutor();
            this.mb.writeLog("\u76d1\u542c\u7b49\u5f85\u65f6\u95f4\uff1a{}", new Object[]{this.pluginParam.getListenWaitTime()});
            this.continuousListen = this.pluginParam.getListenWaitTime() <= 0;
            long maxWaitTime = this.continuousListen ? Long.MAX_VALUE : TimeUnit.MINUTES.toMillis(this.pluginParam.getListenWaitTime());
            this.es.execute(() -> {
                AtomicLong lastGetTime = new AtomicLong(System.currentTimeMillis());
                while (!this.stopped) {
                    ConsumerRecords records;
                    Lock lock = this.readWriteLock.readLock();
                    lock.lock();
                    try {
                        records = this.consumer.poll(Duration.ofSeconds(5L));
                    }
                    finally {
                        lock.unlock();
                    }
                    if (null != records && !records.isEmpty()) {
                        lastGetTime.set(System.currentTimeMillis());
                        for (ConsumerRecord record : records) {
                            try {
                                this.queue.put((String)record.value());
                            }
                            catch (Exception e) {
                                this.mb.writeExceptionLog(e);
                            }
                        }
                        continue;
                    }
                    if (this.continuousListen || System.currentTimeMillis() - lastGetTime.get() < maxWaitTime) continue;
                    this.stopped = true;
                }
            });
        }

        public boolean hasNext() throws Exception {
            return !this.stopped || this.queue.size() != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Record next() throws Exception {
            String json = this.continuousListen ? this.queue.take() : this.queue.poll(1L, TimeUnit.MINUTES);
            if (null == json) {
                return null;
            }
            try {
                JSONObject object = JSONObject.parseObject((String)json);
                Set set = object.entrySet();
                Record record = new Record();
                for (Map.Entry entry : set) {
                    record.add(new Item((String)entry.getKey(), ItemType.STRING, (Serializable)((Object)entry.getValue().toString())));
                }
                int num = this.counter.incrementAndGet();
                if (num >= 500) {
                    Lock lock = this.readWriteLock.writeLock();
                    lock.lock();
                    try {
                        this.consumer.commitSync();
                    }
                    finally {
                        lock.unlock();
                    }
                    this.counter.set(0);
                }
                return record;
            }
            catch (Exception e) {
                this.mb.writeExceptionLog(e);
                throw new IllegalArgumentException("\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\uff1a" + json);
            }
        }

        public long estimateDataNum() {
            return 0L;
        }

        public DataNumEstimateType estimateType() {
            return DataNumEstimateType.CANNOT_ESTIMATE;
        }

        public void begin() throws Exception {
        }

        public void end() throws Exception {
            this.stopped = true;
            if (null != this.es) {
                this.es.shutdown();
                this.es = null;
            }
            if (null != this.consumer) {
                this.consumer.close();
                this.consumer = null;
                this.mb.sendResourceConnectInfo(this.context.flowCode(), this.context.taskCode(), this.context.jobCode(), this.pluginParam.getResourceCode());
            }
            this.mb.writeLog("Kafka\u8bfb\u63d2\u4ef6\u505c\u6b62\u8bfb\u53d6Topic[{}]\u6d88\u606f.", new Object[]{this.pluginParam.getTopic()});
        }

        public PluginType type() {
            return PluginType.READER;
        }

        public Class<? extends PluginParam> pluginParamClass() {
            return KafkaReaderPluginParam.class;
        }

        public String configComponent() {
            return "KafkaReaderConfigForm";
        }
    }
}

