/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.web.common.PermissonTypeEnum;
import com.cpi.framework.web.common.ShiroUser;
import com.cpi.framework.web.common.SystemConstants;
import com.cpi.framework.web.entity.admin.FwOrgPermissons;
import com.cpi.framework.web.entity.admin.FwPermissons;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwStationPermissons;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.entity.admin.FwUserPermissons;
import com.cpi.framework.web.service.admin.AccountService;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;

public class ShiroDbRealm
extends AuthorizingRealm {
    protected AccountService accountService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        FwUser user = this.accountService.findUserByLoginCode(token.getUsername());
        if (user != null) {
            return new SimpleAuthenticationInfo((Object)new ShiroUser(user.getId(), user.getOrgId(), user.getLogincode(), user.getUsername(), user.getOrgName(), user.getStId()), (Object)user.getPassword(), ByteSource.Util.bytes((byte[])"cpi".getBytes()), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        ShiroUser shiroUser = (ShiroUser)principals.getPrimaryPrincipal();
        FwUser user = this.accountService.findUserByLoginCode(shiroUser.getLoginName());
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        HashSet<String> permisson = new HashSet<String>();
        if (PermissonTypeEnum.role.toString().equals(SystemConstants.permissonType)) {
            for (FwRoles role : user.getRoleList()) {
                info.addRole(role.getRoleName());
                for (FwPermissons rolePermisson : role.getPermissonList()) {
                    permisson.add(rolePermisson.getPermissonCode());
                }
            }
        } else if (PermissonTypeEnum.user.toString().equals(SystemConstants.permissonType)) {
            HashSet<Long> permissonIds = new HashSet<Long>();
            List<FwOrgPermissons> orgPLists = this.accountService.findOrgPermissonsByUserId(user.getOrgId());
            List<FwStationPermissons> stationPLists = this.accountService.findStationPermissonsByUserId(user.getStId());
            List<FwUserPermissons> userPLists = this.accountService.findUserPermissonsByUserId(user.getId());
            for (FwOrgPermissons org : orgPLists) {
                permissonIds.add(org.getPermissonId());
            }
            for (FwStationPermissons station : stationPLists) {
                permissonIds.add(station.getPermissonId());
            }
            for (FwUserPermissons userp : userPLists) {
                permissonIds.add(userp.getPermissonId());
            }
            permisson.addAll(this.accountService.findPermissonCodeByPermissonId(permissonIds));
        }
        info.addStringPermissions(permisson);
        return info;
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("MD5");
        matcher.setHashIterations(2);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }
}

