/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.web.common.ShiroUser;
import com.cpi.framework.web.entity.admin.FwPermissons;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.AccountService;
import java.util.HashSet;
import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroCasRealm
extends CasRealm {
    private static Logger log = LoggerFactory.getLogger(ShiroCasRealm.class);
    protected AccountService accountService;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CasToken casToken = (CasToken)token;
        if (token == null) {
            return null;
        }
        String ticket = (String)casToken.getCredentials();
        if (!StringUtils.hasText((String)ticket)) {
            return null;
        }
        TicketValidator ticketValidator = this.ensureTicketValidator();
        try {
            FwUser user;
            boolean isRemembered;
            Assertion casAssertion = ticketValidator.validate(ticket, this.getCasService());
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userId = casPrincipal.getName();
            log.debug("Validate ticket : {} in CAS server : {} to retrieve user : {}", new Object[]{ticket, this.getCasServerUrlPrefix(), userId});
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userId);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            if ((user = this.accountService.findUserByLoginCode(userId)) != null) {
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)new ShiroUser(user.getId(), user.getOrgId(), user.getLogincode(), user.getUsername(), user.getOrgName(), user.getStId()), this.getName());
                return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
            }
            return null;
        }
        catch (TicketValidationException e) {
            throw new CasAuthenticationException("Unable to validate ticket [" + ticket + "]", (Throwable)e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        ShiroUser shiroUser = (ShiroUser)principals.getPrimaryPrincipal();
        FwUser user = this.accountService.findUserByLoginCode(shiroUser.getLoginName());
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        HashSet<String> permisson = new HashSet<String>();
        for (FwRoles role : user.getRoleList()) {
            info.addRole(role.getRoleName());
            for (FwPermissons rolePermisson : role.getPermissonList()) {
                permisson.add(rolePermisson.getPermissonCode());
            }
        }
        return info;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }
}

